
import { Themecontext } from "../context/Themecontext";
import { useContext } from "react";
import { Col } from "react-bootstrap";
import { useEffect } from "react";

const LanguageSwitcher = () => {
  const { showPopup, setShowPopup } = useContext(Themecontext);

  const { i18n } = useTranslation();
  useEffect(() => {
    document.documentElement.style.setProperty(
      "--primary",
      i18n.language === "ta" ? "tamil" : "english"
    );
  }, [i18n.language]);

  const toggleLanguage = () => {
    i18n.changeLanguage(i18n.language === "ta" ? "en" : "ta");
  };

  const getButtonClass = (lang) => {
    return i18n.language === lang ? "active" : "";
  };

  return (
    <Col
      xs={12}
      sm={8}
      md={6}
      className="d-flex  justify-content-center  justify-content-md-end social-icons-header-main mt-md-0 align-items-center gap-3"
    >
      <button
        className={`language-toggle-btn ${getButtonClass("ta")}`}
        onClick={toggleLanguage}
      >
        {i18n.language === "ta" ? "English" : "தமிழ்"}
      </button>
      <a className="btn-booking" size="sm" onClick={() => setShowPopup(true)}>
        Stall Booking
      </a>

    </Col>
  );
};

export default LanguageSwitcher;
