import React, { useContext, useState, useEffect } from "react";
import {
  Navbar,
  Nav,
  Container,
  NavDropdown,
  Offcanvas,
} from "react-bootstrap";
import { TfiAlignCenter } from "react-icons/tfi";
import { Themecontext } from "../context/Themecontext";
import { Link } from "react-router-dom";
import apiService from "../services/apiservices";

const TamilNavbar = () => {
  const { show, handleShow, handleClose } = useContext(Themecontext);
  const [dropdownOpen, setDropdownOpen] = useState(false);
  const [logo, setLogo] = useState("");

  useEffect(() => {
    const fetchLogo = async () => {
      try {
        const response = await apiService.get("users");
        if (response.status === "success" && response.data.length > 0) {
          const profileUrl = response.data[0].profile_url.replace(
            "profiles/",
            ""
          );
          setLogo(
            `https://www.cbf.codissia.com/backend/public/profiles/${profileUrl}`
          );
        }
      } catch (error) {
        console.error("Failed to fetch logo:", error);
      }
    };
    fetchLogo();
  }, []);
  return (
    <>
      <Navbar expand="lg" className="justify-content-lg-center">
        <Container fluid className="justify-content-center">
          <div className="d-flex navbar-logo mb-2  d-lg-none align-items-center justify-content-between w-100 px-3">
            <Link to="/">
              {logo ? (
                <img className="img-fluid logo-img" src={logo} alt="Logo" />
              ) : (
                <p>Loading logo...</p>
              )}
            </Link>
            <div
              className="border-0 shadow-none"
              onClick={handleShow}
              aria-label="Toggle navigation"
            >
              <TfiAlignCenter className="toggle-icon" />
            </div>
          </div>
          <div className="text-center d-block d-lg-none">
          <div className="event-heading ">
                <div className="text-center event-date">
                  <h4>18ᵗʰ - 27ᵗʰ July 2025</h4>
                  <h5>கொடிசியா வர்த்தக கண்காட்சி வளாகம், </h5>
                  <h5>கோயம்புத்தூர் </h5>
                </div>
              </div>
          </div>
          <Navbar.Collapse id="basic-navbar-nav">
            <Nav className="mx-auto fw-bold d-none d-lg-flex">
              <Nav.Link>
                <Link to="/"> முகப்பு </Link>
              </Nav.Link>
              <Nav.Link>
                <Link to="/விருதுகள்">விருதுகள்</Link>
              </Nav.Link>
              <Nav.Link>
                <Link to="/இலக்கியக்கூடல்">இலக்கியக்கூடல்</Link>
              </Nav.Link>
              <Nav.Link>
                <Link to="/அறிவுக்கேணி">அறிவுக்கேணி</Link>
              </Nav.Link>
              <Nav.Link>
                <Link to="/நிகழ்வுகள்">நிகழ்வுகள்</Link>
              </Nav.Link>

              {/* Custom Hover Dropdown */}

              <Nav.Link>
                <Link to="/தொடர்புக்கு">தொடர்புக்கு</Link>
              </Nav.Link>
              <div
                className="custom-dropdown nav-item dropdown"
                onMouseEnter={() => setDropdownOpen(true)}
                onMouseLeave={() => setDropdownOpen(false)}
              >
                <Nav.Link className="dropdown-toggle">கொடிசியா</Nav.Link>
                <div className={`dropdown-menu ${dropdownOpen ? "show" : ""}`}>
                  <NavDropdown.Item>
                    <Link to="/கொடிசியா பற்றியது">கொடிசியா பற்றியது</Link>
                  </NavDropdown.Item>
                  <NavDropdown.Item>
                    <Link to="/வசதிகள்">வசதிகள்</Link>
                  </NavDropdown.Item>
                </div>
              </div>
              <div className="d-flex justify-content-center align-items-center" >
              <Link className="book-stall-main" to="/ஸ்டால் முன்பதிவு">ஸ்டால் முன்பதிவு</Link>
            </div>
            </Nav>
            
          </Navbar.Collapse>
        </Container>
      </Navbar>

      {/* Mobile View: Offcanvas Navigation */}
      <Offcanvas show={show} onHide={handleClose} placement="end">
        <Offcanvas.Header closeButton>
          <Offcanvas.Title> <Link to="/">
              {logo ? (
                <img className="img-fluid logo-img" src={logo} alt="Logo" />
              ) : (
                <p>Loading logo...</p>
              )}
            </Link></Offcanvas.Title>
        </Offcanvas.Header>

        <Offcanvas.Body>
          <Nav className="flex-column fw-bold">
            <Nav.Link onClick={handleClose}>
              <Link to="/">முகப்பு </Link>
            </Nav.Link>
            <Nav.Link onClick={handleClose}>
              <Link to="/விருதுகள்"> விருதுகள்</Link>
            </Nav.Link>
            <Nav.Link onClick={handleClose}>
              <Link to="/இலக்கியக்கூடல்">இலக்கியக்கூடல்</Link>
            </Nav.Link>
            <Nav.Link onClick={handleClose}>
              <Link to="/அறிவுக்கேணி">அறிவுக்கேணி </Link>
            </Nav.Link>
            <Nav.Link onClick={handleClose}>
              <Link to="/நிகழ்வுகள்">நிகழ்வுகள்</Link>
            </Nav.Link>

            <Nav.Link onClick={handleClose}>
              <Link to="/தொடர்புக்கு">தொடர்புக்கு</Link>
            </Nav.Link>
            <NavDropdown title="கொடிசியா" className="">
              <NavDropdown.Item onClick={handleClose}>
                <Link to="/கொடிசியா பற்றியது">கொடிசியா பற்றியது</Link>
              </NavDropdown.Item>
              <NavDropdown.Item onClick={handleClose}>
                <Link to="/வசதிகள்">வசதிகள்</Link>
              </NavDropdown.Item>
            </NavDropdown>
            <div className="d-flex align-items-center book-stall-mobile" onClick={handleClose}>
              <Link className="book-stall-main" to="/ஸ்டால் முன்பதிவு">ஸ்டால் முன்பதிவு</Link>
            </div>
          </Nav>
        </Offcanvas.Body>
      </Offcanvas>
    </>
  );
};

export default TamilNavbar;
