import axios from "axios";
export const url = "https://cbf.codissia.com/backend/api";
export const storage = "https://cbf.codissia.com/backend/public/";
const apiClient = axios.create({
  baseURL: url,
  headers: {
    "Content-Type": "application/json",
    mode: "no-cors",
    "Access-Control-Allow-Origin": "*",
  },
});
const setAuthToken = (token) => {
  if (token) {
    apiClient.defaults.headers["Authorization"] = `Bearer ${token}`;
  } else {
    delete apiClient.defaults.headers["Authorization"];
  }
};

const token =
  "3a5f7e9b12d84f3c8a7e6d1a45b9c2f3d6e8a0b7c4f1d2e3f5a6b8c9e0d1f2g3";
setAuthToken(token);
const get = async (endpoint, params = {}) => {
  try {
    const response = await apiClient.get(endpoint, { params });

    return response.data;
  } catch (error) {
    console.error("Error in GET request:", error.response || error);
    throw error;
  }
};

const post = async (endpoint, data) => {
  try {
    const response = await apiClient.post(endpoint, data);
    console.log("POST response:", response);
    return response.data;
  } catch (error) {
    console.error("Error in POST request:", error.response || error);
    throw error;
  }
};

const put = async (endpoint, data) => {
  try {
    const response = await apiClient.put(endpoint, data);
    return response.data;
  } catch (error) {
    console.error("Error in PUT request:", error);
    throw error;
  }
};

const del = async (endpoint) => {
  try {
    const response = await apiClient.delete(endpoint);
    return response.data;
  } catch (error) {
    console.error("Error in DELETE request:", error);
    throw error;
  }
};
export default {
  get,
  post,
  put,
  del,
};
