

import { BrowserRouter, Route, Routes } from "react-router-dom";
import Layout from "./components/layout/Layout";
import ScrollTopOnLoad from "./components/ScrollTopOnLoad";
import NotFoundPage from "./pages/404/NotFoundPage";
import ProgramsPage from "./pages/Programs/ProgramsPage";
import AnnouncementPage from "./pages/Programs/AnnouncementPage";
import IndigenisationPage from "./pages/Indigenisation/IndigenisationPage";
import HomePage from "./pages/Home/HomePage";
import NewsGalleryPage from "./pages/NewsGallery/NewsGalleryPage";
import TendersPage from "./pages/Tenders/TendersPage";
import GalleryPage from "./pages/Gallery/GalleryPage";
import Preloader from "./components/Preloader";
import { useState, useEffect } from "react";
import PropsContext from "./context/PropsContext";
import AOS from "aos";
import "aos/dist/aos.css"; 
import { ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';
import 'animate.css';
import IncubateesPage from "./pages/Incubation/IncubateesPage";
import IncubationPage from "./pages/Incubation/IncubationPage";
import TeamPage from "./pages/Team/TeamPage";
import InnovationPage from "./pages/Innovation/InnovationPage";
import ContactPage from "./pages/Contact/ContactPage";
import LoginPage from "./components/sections/login/LoginForm";
import NewsGalleryDetailPage from "./pages/NewsGallery/NewsGalleryDetailPage";
import NewsLetterPage from './pages/Newsletter/NewsLetterPage'
import ProgramsMainPage from "./pages/Programs/ProgramsMainPage";


const App = () => {
  const [isLoading, setIsLoading] = useState(true);
  useEffect(() => {
  AOS.init({
    duration: 800,      
    easing: "ease-in-out",
    once: false,         
    mirror: true,       
  });
}, []);

  useEffect(() => {
    
    const timer = setTimeout(() => {
      setIsLoading(false);
    }, 2000);

    return () => clearTimeout(timer);
  }, []);

  return (
    <>
      {isLoading ? (
        <Preloader />
      ) : (
        <BrowserRouter>
          <ScrollTopOnLoad />
          <PropsContext>
            {" "}
             <ToastContainer />
            <Routes>
              <Route path="/" element={<Layout />}>
                <Route index element={<HomePage />} />
                <Route path="/team" element={<TeamPage />} />
                <Route path="/tenders" element={<TendersPage />} />
                <Route path="/programs" element={<ProgramsMainPage />} />
                <Route path="/events" element={<ProgramsPage />} />
                <Route path="/announcements" element={<AnnouncementPage />} />
                <Route path="/innovation" element={<InnovationPage />} />
                <Route path="/indigenisation" element={<IndigenisationPage />} />
                <Route path="/incubation" element={<IncubationPage />} />
                <Route path="/incubatees" element={<IncubateesPage />} />
                <Route path="/photogallery" element={<GalleryPage />} />
                <Route path="/newsgallery" element={<NewsGalleryPage />} />
                <Route path="/contact" element={<ContactPage />} />
                <Route path="/login" element={<LoginPage />} />
                <Route path="/newsletter" element={<NewsLetterPage/>} />
                <Route path="/newsgallerydetail/:id" element={<NewsGalleryDetailPage />} />
               </Route>
                <Route path="*" element={<NotFoundPage />} />
            </Routes>
          </PropsContext>
        </BrowserRouter>
      )}
    </>
  );
};

export default App;
