import { useEffect, useRef, useContext } from "react";
import { FiChevronsRight } from "react-icons/fi";
import { gsap } from "gsap";
import { ScrollTrigger } from "gsap/ScrollTrigger";
import { PropsContext } from "../../../context/PropsContext";

gsap.registerPlugin(ScrollTrigger);

export default function About() {
  const { nextSectionRef } = useContext(PropsContext);
  const sectionRef = useRef(null);

  useEffect(() => {
    const ctx = gsap.context(() => {
      gsap.fromTo(
        ".sec-title, .sec-text, .btn-download",
        {
          y: -80,
          opacity: 0,
        },
        {
          y: 0,
          opacity: 1,
          duration: 2,
          ease: "power3.out",
          stagger: 0.2,
          scrollTrigger: {
            trigger: sectionRef.current,
            start: "top 80%",
            toggleActions: "play none none none",
          },
        }
      );

      gsap.fromTo(
        ".sec-img-one img",
        {
          clipPath: "inset(100% 0 0 0)",
          opacity: 0,
        },
        {
          clipPath: "inset(0% 0 0 0)",
          opacity: 1,
          duration: 2.8,
          ease: "power2.out",
          scrollTrigger: {
            trigger: sectionRef.current,
            start: "top 80%",
          },
        }
      );
    }, sectionRef);

    return () => ctx.revert(); // Clean up on unmount
  }, []);

  return (
    <section
      className="about-sec sec-ptb"
      ref={(el) => {
        sectionRef.current = el;
        nextSectionRef.current = el;
      }}
    >
      <div className="container-fluid sec-ft">
        <div className="row">
          <div className="col-lg-5 mb-5">
            <div className="sec-content">
              <div className="sec-title">
                <h2>Who We Are</h2>
              </div>

              <p className="">
                CDIIC is a not-for-profit Section 8 company established in 2019
                by CODISSIA in Coimbatore, Tamil Nadu, with support from Atal
                Innovation Mission (NITI Aayog) and the Ministry of Defence,
                Government of India. As India’s first Defence Innovation Hub
                under iDEX (Innovations for Defence Excellence), CDIIC plays a
                key role in the Southern Defence Corridor, fostering MSMEs to
                become import substitution partners for the armed forces. It
                aligns with the Startup India initiative, nurturing startups
                through mentorship and incubation until they graduate.
              </p>
              <p className="">
                Since 2019, CDIIC has engaged with MSMEs/SMEs, DPSUs, and the
                Army, Navy, and Air Force, supporting innovation and
                entrepreneurship in defence manufacturing.
              </p>
             
              <div className="btn-download mt-4">
                <a href="#">
                  More{" "}
                  <span className="ps-5">
                    <FiChevronsRight />
                  </span>
                </a>
              </div>
            </div>
          </div>
          <div className="col-lg-7">
            <div className="sec-images">
              <div className="sec-img-one overflow-hidden">
                {/* <img
                  src="/images/about/about01.svg"
                  alt="about-img"
                  className="base-img h-100 img-fluid"
                /> */}
                <img
                  src="/images/about/about.gif"
                  alt="about-gif"
                  className="hover-img h-80 img-fluid"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
