import React, { useContext } from "react";
import { Link } from "react-router-dom";
import { social_links, useful_links } from "../../../data/footer";
import { FiChevronsRight } from "react-icons/fi";
import { PropsContext } from "../../../context/PropsContext";

export default function Footer() {
  const {
    subscriberDatasubscriberData,
    setsubscriberData,
    subscriberDataerrors,
    setsubscriberDataErrors,

    subscriberDataSubmit,
  } = useContext(PropsContext);
  return (
    <footer
      className="footer-sec"
      style={{
        backgroundImage: "url(/images/footer/footer.svg)",
      }}
    >
      <div className="section-overlay sec-pt">
        {/* Footer Info */}
        <div className="container-fluid sec-ft">
          <div className="row">
            {/* First Column - Logo and Description */}
            <div className="col-sm-6 col-xl-3">
              <div className="footer-widget">
                <div className="footer-widget-logo d-flex justify-content-center align-items-center">
                  <Link to="/">
                    <img src="/images/footer/footer-logo.svg" alt="site-logo" />
                  </Link>
                </div>
              </div>
            </div>
            {/* Fourth Column - Address */}
            <div className="col-sm-6 col-xl-3">
              <div className="footer-widget">
                <h4 className="footer-widget-title ">Contact Us</h4>
                <div className="footer-widget-content">
                  <div className="footer-links mb-2">
                    <p>
                      CODISSIA Defence Innovation and Atal Incubation Centre
                      (CDIIC),
                      <br />
                      PB No: 3827, Huzur Road,
                      <br />
                      Coimbatore - 641018
                    </p>
                  </div>
                  <div className="btn-download">
                    <a href="/contact">Contact Us</a>
                  </div>
                </div>
              </div>
            </div>

            {/* Fifth Column - Atal Innovation Logo */}
            <div className="col-sm-6 col-xl-3">
              <div className="footer-widget">
                <div className="footer-widget-logo">
                  <Link to="/">
                    <img
                      src="/images/footer/atalinnovation.svg"
                      alt="atal-innovation-logo"
                    />
                  </Link>
                </div>
              </div>
            </div>
            {/* Fifth Column - Atal Innovation Logo */}
            <div className="col-sm-6 col-xl-3">
              <div className="footer-widget">
                <div className="footer-widget-newsletter">
                  <h4 className="footer-widget-title">News Letter</h4>
                  <div className="newsletter-input">
                    <form onSubmit={subscriberDataSubmit}>
                      <input
                        type="email"
                        name="email"
                        placeholder="Email Address"
                        value={subscriberDatasubscriberData.email}
                        onChange={(e) => {
                          const { name, value } = e.target;
                          setsubscriberData((prev) => ({
                            ...prev,
                            [name]: value,
                          }));

                          if (subscriberDataerrors[name]) {
                            setsubscriberDataErrors((prev) => ({
                              ...prev,
                              [name]: null,
                            }));
                          }
                        }}
                      />

                      <div className="newsletter-icon">
                        <button type="submit">
                          <FiChevronsRight />
                        </button>
                      </div>
                    </form>
                  </div>
                  {subscriberDataerrors.email && (
                    <div className="error-text mb-2">
                      {subscriberDataerrors.email}
                    </div>
                  )}
                  <div className="btn-download">
                    <a href="/newsletter">Newsletter Download</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Nav Links */}
        <div className="container-fluid sec-ft">
          <div className="row d-flex ">
            <div className="col-12">
              <div className="footer-widget pages-links">
                <div className="footer-widget-content">
                  <div className="footer-links">
                    <ul className="d-flex  justify-content-center  footer-link-list">
                      {/* useful link part start */}
                      {useful_links?.map((item, i) => (
                        <li key={i} className="footer-link-item">
                          <Link to={item.url}>
                            <FiChevronsRight className="link-arrow" />
                            {item.name}
                          </Link>
                        </li>
                      ))}
                      {/* useful link part end */}
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* General Info */}
        <div className="container-fluid sec-ft">
          <div className="row footer-copyright">
            <div className="col-lg-4 col-md-12 col-sm-12">
              <div className="footer-copyright-text text-center">
                <p className="mb-0">
                  Copyright © {new Date().getFullYear()} CDIIC. All Rights
                  Reserved
                </p>
              </div>
            </div>
            <div className="col-lg-4 col-md-12 col-sm-12">
              <div className="footer-widget">
                <div className="footer-widget-content">
                  <div className="footer-social">
                    <div className="footer-social-icon d-flex justify-content-center align-items-center">
                      {/* social link part start */}
                      {social_links?.map((item, i) => (
                        <Link key={i} to={item.url} target="_blank">
                          <i className={item.icon} />
                        </Link>
                      ))}
                      {/* social link part end */}
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-lg-4 col-md-12 col-sm-12">
              <div className="footer-copyright-text text-center">
                <p className="mb-0 d-flex justify-content-center justify-content-md-end align-items-center">
                  Designed and Develeped By
                  <a href="https://www.clouddreams.in/">
                    <img
                      className="cd-logo ps-2"
                      src="/images/footer/cd.png"
                      alt="site-logo"
                    />
                  </a>
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}
