import { useState } from "react";
import { Link } from "react-router-dom";
import useHeaderFixed from "../../../hooks/use-header-fixed";
import SidebarNavigation from "../../ui/sidebar/SidebarNavigation";
import Navigation from "./ui/Navigation";


export default function Header() {
  // sticky header
  const isSticky = useHeaderFixed(245);
  const [isOpen, setIsOpen] = useState(false);
  const toggleSidebar = () => setIsOpen(!isOpen);

  return (
    <>
      <header className="main-header main-header-one">
        <div
          id="sticky-header"
          className={`menu-area ${isSticky ? "sticky-menu" : ""}`}
        >
          <div className="main-header-one__outer">
            <div className="main-header-one__right">
              <div className="container-fluid">
                <div className="menu-area__inner">
                  <div className="mobile-nav-toggler align-items-center">
                    <div className="site-ligo">
                      <Link to="/">
                        <img
                          src="/images/header/logo-mobile.svg"
                          alt="site-logo"
                          height={120}
                          width={100}
                        />
                      </Link>
                    </div>
                    <i
                      className="fas fa-bars"
                       onClick={toggleSidebar} 
                      data-bs-toggle="offcanvas"
                      data-bs-target="#offcanvasExample"
                      aria-controls="offcanvasExample"
                     
                    />
                    
                  </div>
                  <div className="menu-wrap">
                    <nav className="menu-nav">
                      <div className="main-header-one__inner">
                        <div className="main-header-one__bottom">
                          <div className="main-header-one__bottom-left d-flex">
                            <div className="site-ligo d-flex align-items-center">
                              <Link to="/">
                                <img
                                  src="/images/header/cdiic.svg"
                                  alt="site-logo"
                                  className="img-fluid"
                                />
                              </Link>
                            </div>
                            {/* navigation part start */}
                            <div className="main-header-one__top-right">
                              <div className="inner">
                                <div className="header-social-links">
                                  <ul>
                                    <li>
                                      <Link href="/">
                                        <i className="fa-brands fa-facebook-f" />
                                      </Link>
                                    </li>
                                    <li>
                                      <Link href="/">
                                        <i className="fa-brands fa-linkedin-in" />
                                      </Link>
                                    </li>
                                    <li>
                                      <Link href="/">
                                        <i className="fa-brands fa-twitter" />
                                      </Link>
                                    </li>
                                    <li>
                                      <Link href="/">
                                        <i className="fa-brands fa-instagram" />
                                      </Link>
                                    </li>
                                  </ul>
                                </div>
                              </div>
                            </div>
                            {/* navigation part end */}
                          </div>
                          <div className="main-header-one__bottom-right">
                            <div className="site-ligo">
                              <Link to="/">
                                <img
                                  src="/images/header/atalinnovation.svg"
                                  alt="site-logo"
                                  className="img-fluid"
                                />
                              </Link>
                            </div>
                          </div>
                        </div>
                        <div className="navigation-desktop">
                          <Navigation />
                        </div>
                      </div>
                    </nav>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </header>
      <SidebarNavigation toggleSidebar={toggleSidebar} isOpen={isOpen} />
    </>
  );
}
