import { useContext, useRef, useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import "swiper/css";
import { Mousewheel } from "swiper/modules";
import { PropsContext } from "../../../context/PropsContext";
import { FiChevronsDown } from "react-icons/fi";


export default function App() {
  const { handleScrollClick } = useContext(PropsContext);
  const swiperWrapperRef = useRef(null);
  const slideRefs = useRef([]);
  const [swiperInstance, setSwiperInstance] = useState(null);
  const [currentSlide, setCurrentSlide] = useState(0);

  const slides = [
    {
      title: "CODISSIA Defence Innovation and Atal Incubation Centre (CDIIC)",
      description:
        "CDIIC is a pioneering incubation centre established by CODISSIA to foster innovation and entrepreneurship in the defence sector. Supported by the Atal Innovation Mission and the Ministry of Defence, it nurtures startups focused on defence technology and innovation in Tamil Nadu.",
    },
    {
      title: "CDIIC – Empowering Defence Startups",
      description:
        "CDIIC empowers defence startups by providing access to advanced resources, mentoring, funding opportunities, and collaboration with industry and government agencies. The centre acts as a catalyst to transform innovative ideas into deployable defence solutions.",
    },
    {
      title: "Defence Innovation Hub – CDIIC Tamil Nadu",
      description:
        "As a dedicated defence innovation hub, CDIIC Tamil Nadu serves as a platform for startups, academia, and industry experts to collaborate, innovate, and accelerate the development of cutting-edge defence technologies that contribute to national security.",
    },
  ];

  const handleSlideChange = (swiper) => {
    setCurrentSlide(swiper.activeIndex);

    slideRefs.current.forEach((slide) => {
      const textEl = slide.querySelector(".slide-text");
      if (textEl) textEl.classList.remove("animate");
    });

    const activeSlide = slideRefs.current[swiper.activeIndex];
    // const activeText = activeSlide.querySelector(".slide-text");
    if (activeText) {
      void activeText.offsetWidth;
      activeText.classList.add("animate");
    }
  };

  const handleRangeChange = (e) => {
    const index = parseInt(e.target.value);
    if (swiperInstance) {
      swiperInstance.slideTo(index);
    }
  };

  return (
    <div className="swiper-fullscreen-wrapper" ref={swiperWrapperRef}>
      <Swiper
        direction="vertical"
        slidesPerView={1}
        spaceBetween={0}
        mousewheel={{ releaseOnEdges: true }}
        modules={[Mousewheel]}
        className="mySwiper"
        onSlideChange={handleSlideChange}
        onSwiper={(swiper) => {
          setSwiperInstance(swiper);
          setTimeout(() => handleSlideChange(swiper), 100);
        }}
      >
        {slides.map(({ title, description }, idx) => (
          <SwiperSlide
            key={idx}
            className="parallax-slide"
            style={{
              backgroundImage: `url(/images/hero/hero-slider${idx + 1}.png)`,
            }}
            ref={(el) => (slideRefs.current[idx] = el)}
          >
            <div className="slide-text">
              <h2>{title}</h2>
              <p>{description}</p>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>

      {/* Range Slider Pagination */}
      <div className="range-pagination">
        <input
          type="range"
          min="0"
          max={slides.length - 1}
          value={currentSlide}
          onChange={handleRangeChange}
        />
        <div className="slide-count">
          {currentSlide + 1} 
        </div>
      </div>

      {/* Scroll Button */}
      <button className="scroll-jump-btn" onClick={handleScrollClick}>
        Scroll Down <FiChevronsDown />
      </button>
    </div>
  );
}