import React, { useRef, useState, useEffect } from "react";
import { gsap } from "gsap";
import { ScrollTrigger } from "gsap/ScrollTrigger";

gsap.registerPlugin(ScrollTrigger);

const Incubatees = () => {
  const [expanded, setExpanded] = useState({});
  const [showAll, setShowAll] = useState(false); // 🔹 State for view more/less
  const containerRef = useRef(null);

  const incubateesData = [
  {
    id: 1,
    title: "Appville Softwares",
    description: "AppvilleSoftwaresoffers cutting-edge Industry 4.0 solutions to help manufacturers transition into smart factories. Their expertise spans rugged Android and iOS mobile apps with features like GPS tracking, delivery scheduling, and tailored solutions for retail and engineering sectors. They also specialize in emerging technologies such as Augmented Reality (AR), Virtual Reality (VR), Mixed Reality (MR), Industrial IoT, Digital Twins, and end-to-end digitalization—empowering industries to adopt the Manufacturing 4.0 strategy seamlessly.",
    image: "/images/incubatees/cover/1.png",
    logo: "/images/incubatees/1.png"
  },
  {
    id: 2,
    title: "Arputha Technologies",
    description: "Arputha Technologies, established in January 2020, is a product development company and a trusted name among leading manufacturers and suppliers. They specialize in innovative solutions across Consumer Electronics, Industrial Automation, and Automotive sectors. Known for their rugged designs, precision performance, and maintenance-free reliability, their products deliver hassle-free operation and are widely recognized for their quality and durability in demanding environments.",
    image: "/images/incubatees/cover/2.png",
    logo: "/images/incubatees/2.png"
  },
  {
    id: 3,
    title: "Avatar Aviation & Aerospace Pvt Ltd",
    description: "Avatar Aviation & Aerospace Private Limited is a leading aviation solutions provider with a strong presence across India. Backed by a team of experienced AMEs, pilots, and engineers, the company has delivered several award-winning projects for Aeronautical and Mechanical students and institutions. Avatar Aviation specializes in refurbishing and supplying 2- and 5-seater aircraft in ground running condition, and has successfully re-engineered over 28 engines including Tumansky R-11, ASV-12 turbojets, turboprops, and Lycoming and Continental piston engines.",
    image: "/images/incubatees/cover/3.png",
    logo: "/images/incubatees/3.png"
  },
  {
    id: 4,
    title: "Bala Aatral Solutions Pvt Ltd",
    description: "BalaAatral Solutions Private Limited, founded in 2017 and based in Chennai, is a deep tech company specializing in AR, VR, and Metaverse-based industrial solutions. Aatral focuses on enhancing process operations, safety training, audits, and induction programs through immersive technologies. With three prestigious IDEX wins, the company is currently collaborating with the Indian Army, Air Force, and Navy on cutting-edge projects, including VR-based helicopter simulators, ground crew maintenance training, and AI-powered smart glasses for real-time troubleshooting.",
    image: "/images/incubatees/cover/4.png",
    logo: "/images/incubatees/4.png"
  },
  {
    id: 5,
    title: "Dataspire Technologies Private Limited",
    description: "Dataspire Technologies Private Limited, is an IT, consulting, and outsourcing company specializing in Database and Infrastructure Management. Founded by a team of passionate professionals, Dataspire delivers customer-centric consulting with a strong focus on satisfaction and innovation. They offer productized applications and platforms tailored for Big Data and custom application development, giving clients a competitive edge across industries. Their end-to-end database services include creation, migration, 24/7 monitoring (remote or onsite), disaster recovery, network management, and security. Their strength lies in deep technical expertise and a commitment to quality and timely delivery.",
    image: "/images/incubatees/cover/5.png",
    logo: "/images/incubatees/5.png"
  },
  {
    id: 6,
    title: "DVIZIRA Private Limited",
    description: "DVIZIRA Private Limited, founded in 2016, is a military systems R&D startup focused on developing cutting-edge C4I technologies to enhance soldier capabilities on the battlefield. Backed by over 30 years of combined experience in technology and management, and mentored by a veteran of the Indian Army specializing in counter-insurgency and counter-terrorism, DVIZIRA is committed to delivering innovative and mission-critical solutions for the defence forces.",
    image: "/images/incubatees/cover/6.png",
    logo: "/images/incubatees/6.png"
  },
  {
    id: 7,
    title: "Edgeforce Solutions Private Limited",
    description: "Edgeforce Solutions Private Limited was founded with the mission to deliver cutting-edge, disruptive technologies to strengthen the nation’s security forces. With rising internal and external threats, Edgeforce focuses on building advanced, homegrown capabilities to create a critical technology edge. Their end-to-end solutions extend beyond defence, impacting sectors like PSUs, logistics, ports, and mining. As a proud contributor to Industry 4.0, Edgeforce also specializes in developing connected Digital Twins for modern physical assets.",
    image: "/images/incubatees/cover/7.png",
    logo: "/images/incubatees/7.png"
  },
  {
    id: 8,
    title: "Garudan Unmanned System Private Limited",
    description: "Garudan Unmanned System Private Limited is a technology-driven product development startup specializing in reliable UAV solutions for Defence, Aerospace, and Commercial applications. Backed by a skilled team with deep expertise in drone engineering and customization, Garudan combines innovation with practical design to deliver efficient, connected, and user-friendly solutions.",
    image: "/images/incubatees/cover/8.png",
    logo: "/images/incubatees/8.png"
  },
  {
    id: 9,
    title: "Grass Root Advanced Systems Private Limited",
    description: "Grass Root Advanced Systems Private Limited is a dynamic startup led by a skilled team of engineers, focused on solving key challenges in the UAV sector. Aligned with the Atmanirbhar Bharat mission, GRAS is developing cost-effective, high-endurance drones to address the critical issue of limited flight time. With a patented concept, the company aims to enable UAVs to stay airborne for extended periods, unlocking applications across security, surveillance, wildlife monitoring, agriculture, cinematography, and exploration.",
    image: "/images/incubatees/cover/9.png",
    logo: "/images/incubatees/9.png"
  },
  {
    id: 10,
    title: "Greenamp Technos (OPC) Private Limited",
    description: "Greenamp Technos (OPC) Private Limited, founded in 2021, is a forward-looking startup focused on developing energy storage solutions in India. Backed by a team of experts in batteries and fuel cells, Greenamp leverages deep automotive industry and research experience to deliver tailored solutions for automotive, residential, and commercial applications. The company is committed to enabling sustainable, affordable energy storage to help combat climate change and reduce greenhouse emissions.",
    image: "/images/incubatees/cover/10.png",
    logo: "/images/incubatees/10.png"
  },
  {
    id: 11,
    title: "Innospire Electrotech Private Limited",
    description: "Innospire Electrotech Private Limited is a technology company specializing in imaging and image processing, delivering vision-based inspection solutions across automotive, pharmaceutical, and manufacturing sectors. With strong expertise in selecting the right hardware—cameras, lenses, and lighting—the company partners with leading German and global providers. Backed by a seasoned software team with over a decade of experience, Innospire develops advanced image processing solutions tailored to industrial needs.",
    image: "/images/incubatees/cover/11.png",
    logo: "/images/incubatees/11.png"
  },
  {
    id: 12,
    title: "Jesuans Engineering India Private Limited",
    description: "Jesuans Engineering India Private Limited is a leading Solar EPC solutions provider in South India, specializing in end-to-end solar energy systems. With a certified and professionally managed team, the company offers engineering, procurement, and construction services under one roof. Jesuans partners with top solar technology providers to deliver rooftop solar plants, solar water pumping systems, lighting solutions, and custom solar products tailored to client needs.",
    image: "/images/incubatees/cover/12.png",
    logo: "/images/incubatees/12.png"
  },
  {
    id: 13,
    title: "Mano Aircraft Private Limited",
    description: "Mano Aircraft Private Limited, based in Coimbatore, is an Indian-origin company founded by Pranesh and Vignesh to demonstrate and advance homebuilt aircraft manufacturing capabilities. Driven by a passion for innovation, Mano Aircraft focuses on cutting-edge design, advanced manufacturing techniques, and uncompromised safety to ensure high-quality flying experiences.",
    image: "/images/incubatees/cover/13.png",
    logo: "/images/incubatees/13.png"
  },
  {
    id: 14,
    title: "Nunnari Labs Pvt. Ltd.",
    description: "Nunnari Labs Pvt. Ltd. is an Industry 4.0 consulting and solution development firm with verticals in Education, Software Development, and R&D—operating under Nunnari Academy, Nunnari IT Solutions, and Nunnari Labs. The company specializes in AI, IoT, AR/VR, Blockchain, Cloud, and Web Technologies. Nunnari Academy provides training in AI and IoT for academic and corporate clients, with a strong focus on student knowledge transfer and innovation. The R&D division focuses on intelligent embedded systems, computer vision, and AI-powered navigation systems for drones and UGVs in GNSS-denied environments. Nunnari IT Solutions offers software and cloud-based remote monitoring systems for predictive and preventive maintenance.",
    image: "/images/incubatees/cover/14.png",
    logo: "/images/incubatees/14.png"
  },
  {
    id: 15,
    title: "RakshaKavach Tech Private Limited",
    description: "RakshaKavach Tech Private Limited specializes in the manufacturing of defence-grade textiles. The company is dedicated to producing high-performance materials tailored for military applications, ensuring durability, protection, and reliability in critical operations.",
    image: "/images/incubatees/cover/15.png",
    logo: "/images/incubatees/15.png"
  },
  {
    id: 16,
    title: "Resilience Business Grids LLP (RBG)",
    description: "Resilience Business Grids LLP (RBG) is an AI research-driven company focused on developing solutions to structure unstructured data across text, images, video, speech, and numerical inputs. At the core of RBG's innovation is the MLstack—a proprietary machine learning service stack designed to tackle complex business challenges across industries. RBG is committed to democratizing advanced AI technologies to drive sustainable and scalable business growth.",
    image: "/images/incubatees/cover/16.png",
    logo: "/images/incubatees/16.png"
  },
  {
    id: 17,
    title: "SKYX Aerospace Private Limited",
    description: "SKYX Aerospace Private Limited is a rapidly growing drone technology company committed to delivering high-quality, reliable solutions. With strong operational expertise, SKYX offers economical drone-based services integrated with advanced software and analytics to enhance efficiency. The company specializes in Drone Manufacturing, Drone-as-a-Service (DaaS), and Drone-based IT Solutions, positioning itself as one of India’s most dependable drone startups.",
    image: "/images/incubatees/cover/17.png",
    logo: "/images/incubatees/17.png"
  },
  {
    id: 18,
    title: "Spacerolls Aerospace Technologies Private Limited",
    description: "Spacerolls Aerospace Technologies Private Limited is a deep-tech startup pioneering the development of axial flow compressor technology for next-generation gas turbine jet engines. Focused on applications in aviation and defence, Spacerolls is driving innovation at the core of propulsion systems.",
    image: "/images/incubatees/cover/18.png",
    logo: "/images/incubatees/18.png"
  },
  {
    id: 19,
    title: "Vellon Space Private Limited",
    description: "Vellon Space Private Limited, founded in 2019 in Madurai, is an Indian commercial small satellite launch company focused on end-to-end space transportation solutions. Addressing the challenges faced by small satellite operators, Vellon Space aims to increase launch frequency and offer dedicated, on-demand missions. Its Rudra series of launch vehicles is designed to support the New Launch Era with reliable and efficient access to space.",
    image: "/images/incubatees/cover/19.png",
    logo: "/images/incubatees/19.png"
  },
  {
    id: 20,
    title: "Vikra Ocean Tech Private Limited",
    description: "Vikra Ocean Tech Private Limited is an emerging deep-tech company addressing complex underwater challenges across sectors like aquaculture, naval operations, environmental research, and oil & gas. In a short span, it has established itself as a trusted manufacturer and solution provider, offering advanced platforms such as Autonomous Surface Vehicles (ASVs), Remotely Operated Underwater Drones (ROUDs), and Autonomous Ground Vehicles (AGVs) tailored to client needs.",
    image: "/images/incubatees/cover/20.png",
    logo: "/images/incubatees/20.png"
  },
  {
    id: 21,
    title: "Virmodello Technologies Private Limited",
    description: "Virmodello Technologies Private Limited, an ISO-certified startup founded in 2018, empowers engineering companies to transform ideas into products through model and simulation-based development. By enabling Industry 4.0 standards, Virmodello ensures optimized product outcomes. Backed by a passionate team of engineers, domain experts, and seasoned advisors, the company delivers innovative and practical solutions to complex engineering challenges.",
    image: "/images/incubatees/cover/21.png",
    logo: "/images/incubatees/21.png"
  },
  {
    id: 22,
    title: "Xnomous Systems Pvt. Ltd.",
    description: "Xnomous Systems Pvt. Ltd. designs and develops autonomous systems for rugged industrial applications across land, air, water, and space. The company specializes in integrating diverse autonomous technologies into a unified, interoperable ecosystem, enabling seamless operation across multiple domains.",
    image: "/images/incubatees/cover/22.png",
    logo: "/images/incubatees/22.png"
  },
  {
    id: 23,
    title: "Zeekers Employment Pvt. Ltd.",
    description: "Zeekers Employment Pvt. Ltd. is a mission-driven company focused on delivering affordable life and employment skills through Virtual Reality (VR) intervention. With a vision to skill 1 million youth using AR/VR technologies, Zeekers aims to enhance employability and contribute to the sustainable development of the nation.",
    image: "/images/incubatees/cover/23.png",
    logo: "/images/incubatees/23.png"
  },
  {
    id: 24,
    title: "RobotoAI Technologies",
    description: "RobotoAI Technologies delivers cutting-edge robotics and autonomous solutions for industries and educational institutions. Specializing in AI-powered autonomous mobile robots, the company is transforming material handling and logistics. With expertise in industrial automation, medical devices, and mission-critical electronic systems, RobotoAI is driven by deep tech innovation and a passion for shaping the future of intelligent automation.",
    image: "/images/incubatees/cover/24.png",
    logo: "/images/incubatees/24.png"
  },
  {
    id: 25,
    title: "CommandHQ",
    description: "CommandHQ delivers mission-critical defence solutions that integrate advanced technologies, strategic intelligence, and operational expertise to protect national interests and maintain strategic superiority.",
    image: "/images/incubatees/cover/25.png",
    logo: "/images/incubatees/25.png"
  },
  {
    id: 26,
    title: "Birdscale Technology",
    description: "Birdscale Technology addresses critical inefficiencies in infrastructure and agriculture by eliminating manual data logging and fragmented site inspections. Leveraging autonomous platforms powered by drones, satellites, and AI, Birdscale delivers real-time progress tracking, stress detection, and actionable insights—without requiring on-site personnel. As a fully plug-and-play solution, the company manages the entire process end-to-end, providing clients with seamless “flight to insight” intelligence.",
    image: "/images/incubatees/cover/26.png",
    logo: "/images/incubatees/26.png"
  },
  {
    id: 27,
    title: "Delving Energy EcoSystems ",
    description: "Delving Energy EcoSystems is an IoT-driven company pioneering sustainable solutions through innovation in electrical, electronics, and embedded system design. With strong R&D capabilities, the company transforms ideas into manufacturable products. Its flagship device, DelSmart, is produced in-house with 90% indigenized content—relying only on imported microcontrollers. With a current manufacturing capacity of 1,000 units per month, Delving Energy delivers scalable, high-impact solutions for a smarter, greener future.",
    image: "/images/incubatees/cover/27.png",
    logo: "/images/incubatees/27.png"
  },
  {
    id: 28,
    title: "Yali Aerospace",
    description: "Yali Aerospace develops innovative, autonomous drone solutions for medical, surveillance, and logistics applications, with a mission to enhance and save lives globally. Specializing in emergency response, Yali’s drone networks enable rapid and reliable delivery of critical supplies. With a bold vision to revolutionize healthcare and logistics in India, the company is building a first-response drone network capable of reaching any location within 20 minutes.",
    image: "/images/incubatees/cover/28.png",
    logo: "/images/incubatees/28.png"
  },
  {
    id: 29,
    title: "Reliamotive Labs Pvt. Ltd.",
    description: "Reliamotive Labs Pvt. Ltd., based in Bangalore, is a next-gen technology company specializing in development, consulting, and software distribution. The firm provides global solutions for industries, research organizations, and academic institutions in the fields of Electro-Mechanical Systems, Electrical Engineering, Embedded Electronics, and Real-Time Operating Systems, with a strong focus on electrification. Backed by a highly skilled and experienced team, Reliamotive consistently delivers optimized results for complex and mission-critical projects.",
    image: "/images/incubatees/cover/29.png",
    logo: "/images/incubatees/29.png"
  },
  {
    id: 30,
    title: "UI Bridge",
    description: "UI Bridge, founded in 2020, is a cutting-edge engineering company offering end-to-end solutions in Product Engineering, Process Engineering, and Sourcing Services. By leveraging digital engineering practices, UI Bridge drives efficiency, innovation, and sustainability across every stage of the engineering lifecycle.",
    image: "/images/incubatees/cover/30.png",
    logo: "/images/incubatees/30.png"
  },
  {
    id: 31,
    title: "Microgravity (μg)Exploration LLP",
    description: "Microgravity (μg)Exploration LLP is pioneering the development of advanced composite materials, uniquely engineered for aerospace, defence, and allied applications. The company is also developing India’s first-of-its-kind Unmanned Aerial System (UAS) with over 3 hours of endurance in high and medium altitude terrains, tailored for space and defence missions.",
    image: "/images/incubatees/cover/31.png",
    logo: "/images/incubatees/31.png"
  },
  {
    id: 32,
    title: "Biggen Aerospace",
    description: "Biggen Aerospace (formerly Model Aviation), established in 2009, is a pioneer in the design, development, and integration of fully autonomous Helicopter UAVs, Hybrid VTOLs, and Fixed-Wing Unmanned Aerial Systems for both defence and commercial applications. As the first to introduce Helicopter UAVs in India, the company revolutionized aerial photography and videography.",
    image: "/images/incubatees/cover/32.png",
    logo: "/images/incubatees/32.png"
  },
  {
    id: 33,
    title: "TechGenziPvt. Ltd.",
    description: "TechGenziPvt. Ltd. delivers bespoke, customer-centric solutions to address complex industry challenges. The company’s flagship offering, the Integrated Productivity Solutions Suite (IPSS), is a comprehensive platform designed specifically for manufacturing industries. IPSS empowers businesses to streamline operations, optimize capacity, and drive sustainable growth—enabling manufacturers to plan, manage, and execute with precision.",
    image: "/images/incubatees/cover/33.png",
    logo: "/images/incubatees/33.png"
  },
  {
    id: 34,
    title: "Solto Innovation and Aviation Pvt. Ltd.",
    description: "Solto Innovation and Aviation Pvt. Ltd. has developed a lightweight, portable, and airworthy Patient Transportation Unit (PTU) tailored to address the challenges faced by the Indian Air Force during patient transfers. Weighing approximately 18 kg, including the stretcher and equipment holder, the PTU is designed for flexibility, ease of use, and operational efficiency.",
    image: "/images/incubatees/cover/34.png",
    logo: "/images/incubatees/34.png"
  },
  {
    id: 35,
    title: "Vantage Flow ",
    description: "Vantage Flow leverages advanced open-source large language models like LLAMA 2, PaLM, and Dolly to enable real-time monitoring of social media, public forums, and other digital platforms. Designed to support intelligence and security operations, Vantage Flow offers Real-time threat monitoring, Visual and statistical insights andInstant alert systems.",
    image: "/images/incubatees/cover/35.png",
    logo: "https://placehold.co/80x80"
  }
];

  const toggleReadMore = (id) => {
    setExpanded((prev) => ({
      ...prev,
      [id]: !prev[id],
    }));
  };

  useEffect(() => {
    if (containerRef.current) {
      gsap.fromTo(
        containerRef.current.querySelectorAll(".incubee-card"),
        { opacity: 0, y: 50 },
        {
          opacity: 1,
          y: 0,
          duration: 0.2,
          stagger: 0.15,
          ease: "power2.out",
          scrollTrigger: {
            trigger: containerRef.current,
            start: "top 80%",
          },
        }
      );
    }
  }, []);

  // 🔹 Show only first 9 when not expanded
  const visibleIncubatees = showAll ? incubateesData : incubateesData.slice(0, 9);

  return (
    <div className="incubatees-section sec-ptb">
      <div className="container" ref={containerRef}>
        <div className="sec-content text-center mb-5">
          <h6 className="sec-sub-title">Our Incubates</h6>
          <h2 className="teamx-title">Explore Our Incubates</h2>
        </div>

        <div className="row g-4">
          {visibleIncubatees.map((incubee) => (
            <div key={incubee.id} className="col-md-4">
              <div className="incubee-card">
                <div className="incubee-img-container">
                  <div className="incubee-logo">
                    <img src={incubee.logo} alt={`${incubee.title} logo`} />
                  </div>
                </div>
                <div className="incubee-content">
                  <h3 className="incubee-title">{incubee.title}</h3>
                  <p
                    className={`incubee-description ${
                      expanded[incubee.id] ? "expanded" : "clamped"
                    }`}
                  >
                    {incubee.description}
                  </p>
                  <button
                    className="read-toggle-btn"
                    onClick={() => toggleReadMore(incubee.id)}
                  >
                    {expanded[incubee.id] ? "Read Less" : "Read More"}
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* 🔹 View More / View Less Button */}
        {incubateesData.length > 9 && (
          <div className="text-center mt-4">
            <button
              className="view-toggle-btn btn btn-readmore"
              onClick={() => setShowAll(!showAll)}
            >
              {showAll ? "View Less" : "View More"}
            </button>
          </div>
        )}
      </div>
    </div>
  );
};

export default Incubatees;
