import React, { useEffect, useRef } from "react";
import { Container, Row, Col } from "react-bootstrap";
import { FaLightbulb, FaShieldAlt,FaHandshake  } from "react-icons/fa";
import {FiChevronsRight } from "react-icons/fi";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay } from "swiper/modules";
import { FaIndustry,FaTools, FaDollarSign, FaUsers, FaMicrophoneAlt, FaChartLine, FaBullhorn } from 'react-icons/fa';
import { FaLeaf} from 'react-icons/fa';
import { MdShield } from 'react-icons/md';
import { RiFolderUserLine } from "react-icons/ri";
import { FaLink } from 'react-icons/fa';


import "swiper/css";
import "swiper/css/navigation";
import { gsap } from "gsap";
import MissionVision from "./MissionVision";
// Facilities

const sections = [
  {
    icon: <FaLightbulb size={40} className=" mb-3" />,
    title: "Innovation",
    text: "Empowering startups and incubating new ideas to support entrepreneurship.",
  },
  {
    icon: <FaShieldAlt size={40} className=" mb-3" />,
    title: "Defence",
    text: "Key contributor to the Southern Defence Corridor and armed forces support.",
  },
  {
    icon: <FaHandshake size={40} className=" mb-3" />,
    title: "Collaboration",
    text: "Strong networks with MSMEs, DPSUs, and the three defence forces.",
  },
];

const items = [
  {
    id: 1,
    img: "./images/incubation/facilities/1.png",
    title: "Strategic Role in the Southern Defence Corridor",
    content: "Key contributor to the Southern Defence Corridor",
  },
  {
    id: 2,
    img: "./images/incubation/facilities/2.png",
    title: "Empowering Coimbatore MSMEs for Defence Import Substitution",
    content:
      "Enabling the MSMEs of Coimbatore to become import substitution partners to the armed forces.",
  },
  {
    id: 3,
    img: "./images/incubation/facilities/3.png",
    title: "Nurturing Startups Through Government Initiatives",
    content:
      "In line with the Start-up India Movement of the Government of India, to nurture the start-ups and handhold them till they graduate.",
  },
  {
    id: 4,
    img: "./images/incubation/facilities/4.png",
    title: "Incubation and Mentorship Support",
    content:
      "Required support and guidance provided to start-ups in terms of incubation of their ideas through mentors and institutions, thereby helping them to graduate.4",
  },
  {
    id: 5,
    img: "./images/incubation/facilities/5.png",
    title: "Fostering Entrepreneurship and Employment",
    content:
      "Catalyst in developing new entrepreneurs who in-turn would set up their own industries generating employment opportunities to many.5",
  },
  {
    id: 6,
    img: "./images/incubation/facilities/6.png",
    title: "Collaborative Ecosystem with Defence and MSMEs",
    content:
      "Networks established with various vendors, members of MSMEs/SMEs, the DPSUs and the three forces – Army, Navy and Air Force.",
  },
];

const trainings = [
  {
    icon: <FaIndustry/>,
    title: "Strategic Role in the Southern Defence Corridor",
    desc: "Technical Seminar",
  },
  {
    icon: <FaHandshake/>,
    title: "Empowering Coimbatore MSMEs for Defence Import Substitution",
    desc: "Founders Chair—Motivational Session",
  },
  {
    icon: <FaLightbulb/>,
    title: "Intellectual Property Rights Awareness",
    desc: "IPR",
  },
  {
    icon: <FaTools/>,
    title: "Skill Enhancement through Workshops",
    desc: "Workshops",
  },
  {
    icon: <FaDollarSign/>,
    title: "Funding and Business Pitch Opportunities",
    desc: "Fund / Business pitch",
  },
  {
    icon: <FaUsers/>,
    title: "Strengthening Bonds through Team Building",
    desc: "Team building",
  },
  {
    icon: <FaMicrophoneAlt/>,
    title: "Insights from Industry Experts",
    desc: "Conferences",
  },
  {
    icon: <FaChartLine/>,
    title: "Building and Presenting Effective Business Plans",
    desc: "Business Plan",
  },
  {
    icon: <FaBullhorn/>,
    title: "Accelerating Growth through Marketing and Sales",
    desc: "Marketing and Sales",
  },
];

const facilities = [
  {
    icon: <FaLightbulb/>,
    title: "Comprehensive Startup Kit",
    desc: "Essential resources and tools provided to kickstart entrepreneurial journeys effectively.",
  },
  {
    icon: <FaLeaf/>,
    title: "Eco-Friendly Co-working Space",
    desc: "Startup-friendly, fully furnished co-working space designed to foster collaboration and sustainability.",
  },
  {
    icon: <FaUsers/>,
    title: "Human Resource Support",
    desc: "Assistance in recruitment, talent management, and organizational development for startups.",
  },
  {
    icon: <RiFolderUserLine/>,
    title: "Expert Mentoring Programs",
    desc: "Guidance from seasoned mentors to shape strategies and scale innovations.",
  },
  {
    icon: <FaDollarSign/>,
    title: "Funding Opportunities",
    desc: "Access to funding support through grants, seed capital, and venture investments.",
  },
  {
    icon:  <MdShield />,
    title: "Defence Sector Engagement",
    desc: "Connecting startups with defence organizations to explore innovative solutions and collaborations.",
  },
  {
    icon: <FaHandshake/>,
    title: "Investor Connect Programs",
    desc: "Bridging startups with angel investors and VCs for funding and strategic guidance.",
  },
  {
    icon: <FaIndustry/>,
    title: "Industry Collaborations",
    desc: "Opportunities to partner with established industries for innovation, validation, and scale.",
  },
  {
    icon: <FaLink/>,
    title: "Business Networking Platforms",
    desc: "Enabling meaningful connections through curated networking events and startup forums.",
  },
];


const Incubation = () => {
  const sectionRef = useRef(null);

  useEffect(() => {
    gsap.fromTo(
      sectionRef.current.querySelectorAll(".cdiic-notice-card"),
      {
        opacity: 0,
        y: 40,
      },
      {
        opacity: 1,
        y: 0,
        duration: 0.8,
        stagger: 0.2,
        ease: "power2.out",
      }
    );
  }, []);

  return (
    <section className="py-5 bg-light cdiic-notice-section" ref={sectionRef}>
      <div className="container mb-5">
        <div className="row">
          <div className="col-lg-6 mb-4">
            <div>
              <img
                className="img-fluid"
                src="/images/incubation/cdiic-building.jpg"
                alt=""
                srcset=""
              />
            </div>
          </div>
          <div className="col-lg-6 commitment-section  ">
            <div className="mb-3">
              <p className="text-muted mb-1 incubation-info-heading">
                CDIIC — Kallapalayam, Coimbatore
              </p>
              <div>
                <h4 className="fw-500 ">Our Commitment</h4>
              </div>
            </div>

            <p className="mb-3">
              CODISSIA has provided 1 acre of land, with about 12,500 Sq. Ft. of
              infrastructure constructed for the setup of the Defence Innovation
              and Incubation Centre at the CODISSIA Industrial Park site in
              Kallapalayam village, approximately 25 km from Coimbatore.
            </p>

            <div className="btn-download mt-4">
              <a href="CDIIC Incubatee Application Form.pdf" target="_blank">
                Download Application Form{" "}
                <span className="ps-5">
                  <FiChevronsRight />
                </span>
              </a>
            </div>

            <p className="text-danger">
              <strong>Note:</strong>
            </p>
            <p>
              <span>
                Download the above application form and mail the scanned copy of
                the filled and signed form to
              </span>{" "}
              <a
                href="mailto:info@cdiic.in"
                className="text-decoration-underline"
              >
                info@cdiic.in
              </a>
            </p>
          </div>
        </div>
      </div>
      {/* ------ 1 ---------- */}
      <div className="container mb-5 mt-5">
        <div className="row justify-content-center g-4">
          {sections.map(({ icon, title, text, index }) => (
            <div key={index} className="col-12 col-md-6 col-lg-4">
              <div className="stylish-card p-3 text-center">
                <div className="section-number">{icon}</div>
                <h5 className=" mt-2 mb-2">{title}</h5>
                <p className="">{text}</p>
              </div>
            </div>
          ))}
        </div>
      </div>
      <div className="carouselSlider__container__main mt-5">
        <div className="container-fluid">
          <div className="carouselSlider__container">
            <div className="mb-4 incubation-header text-center">
              <h6 className="fw-bold">Facilities</h6>
              <h2 className="fw-bold mb-3 text-white">Facilities @ CDIIC</h2>
              <p className=" mb-4">
                Facilitating strong networks between MSMEs, DPSUs, and the Armed
                Forces.
              </p>
            </div>
            <div className="mt-5">
              <Swiper
                modules={[Navigation, Autoplay]} // Add Autoplay
                navigation={{
                  nextEl: ".carouselSlider__next",
                  prevEl: ".carouselSlider__prev",
                }}
                autoplay={{
                  delay: 3000, // 3 seconds
                  disableOnInteraction: false, // autoplay continues after interaction
                }}
                loop={true} // Enable looping
                spaceBetween={20}
                slidesPerView={1}
                breakpoints={{
                  640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                  },
                  768: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                  },
                  1024: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                  },
                  1200: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                  },
                  1400: {
                    slidesPerView: 4,
                    spaceBetween: 20,
                  },
                }}
                className="carouselSlider__swiper"
              >
                {items.map((item, index) => (
                  <SwiperSlide key={item.id}>
                    <div
                      className={`carouselSlider__item ${
                        index % 2 !== 0 ? "carouselSlider__item--even" : ""
                      }`}
                    >
                      <div className="carouselSlider__item__info">
                        {index + 1}
                      </div>
                      <img
                        className="img-fluid"
                        src={item.img}
                        alt=""
                        srcset=""
                      />
                      <h3 className="carouselSlider__title">{item.title}</h3>
                      <p className="carouselSlider__content">{item.content}</p>
                    </div>
                  </SwiperSlide>
                ))}
              </Swiper>

              <button className="carouselSlider__prev carouselSlider__arrow">
                &lt;
              </button>
              <button className="carouselSlider__next carouselSlider__arrow">
                &gt;
              </button>
            </div>
          </div>
        </div>
      </div>
      <MissionVision />
      {/* 3 */}
      <Container className="mb-5 mt-5">
        <Row>
          <Col className="mb-5" md={12}>
            <div className="mb-5 incubation-header-main">
              <h2 className="fw-bold ">Trainings @ CDIIC</h2>
              <p className=" mb-4">
                Empowering startups through structured training programs led by
                industry experts.
              </p>
            </div>
            <div className="incubation-info row">
              {trainings.map((notice, index) => (
                <div className="col-lg-4 col-md-6 col-sm-6 col-12 mb-3 cdiic-notice-card-main" key={index}>
                  <div
                    className="cdiic-notice-card hover-lift transition h-100"
                  >
                    <p className="text-muted mb-0">
                      <span className="notice-count me-2">{index + 1}</span>

                      <div className="flex-column notice-arrow-info">
                        <h4>{notice.desc}</h4>
                        <div>
                          <p> {notice.title}</p>
                        </div>
                      </div>
                      <hr />
                    </p>
                    <span className="notice-arrow me-2">
                      {" "}
                     {notice.icon}
                    </span>
                  </div>
                </div>
              ))}


            </div>
          </Col>
          {/* RIGHT COLUMN */}
          <Col md={12}>
            <div className="mb-5 incubation-header-main">
              <h2 className="fw-bold">
                Facilities For Physical / Virtual Incubators @ CDIIC
              </h2>
              <p className="text-muted mb-4">
                Empowering startups through structured training programs led by
                industry experts.
              </p>
            </div>
           <div className="incubation-info row">
              {/* Corrected mapping for facilities */}
              {facilities.map((facility, index) => (
                <div className="col-lg-4 col-md-6 col-sm-6 col-12 mb-3 cdiic-notice-card-main" key={index}>
                  <div
                    className="cdiic-notice-card hover-lift transition h-100"
                  >
                    <p className="text-muted mb-0">
                      <span className="notice-count me-2">{index + 1}</span>

                      <div className="flex-column notice-arrow-info">
                        <h4>{facility.title}</h4> {/* Changed from facilities.desc to facility.desc */}
                        <div>
                          <p>{facility.desc} </p> {/* Changed from facilities.title to facility.title */}
                        </div>
                      </div>
                      <hr />
                    </p>
                    <span className="notice-arrow me-2">
                      {" "}
                     {facility.icon} {/* Changed from facilities.icon to facility.icon */}
                    </span>
                  </div>
                </div>
              ))}


            </div>
          </Col>
        </Row>
      </Container>
    </section>
  );
};

export default Incubation;