import React, { useState } from "react";
import { GoChevronRight } from "react-icons/go";

const IndigenisationAddition = () => {
  const [activeIndex, setActiveIndex] = useState(0); // Default show first item

  const data = [
    {
      title: "SCOPE",
      subtitle: "Objectives and focus areas",
      description: [
        "Expedite registration process of manufacturers with DGQA for Defence Revenue Procurement.",
        "Share registered vendor lists with Indian Army, Navy, Air Force, OFs, and DPSUs for participation in procurement and indigenisation schemes (Make in India, Atmanirbhar Bharat).",
        "Advance CODISSIA's proposal for testing facilities in the South Defence Corridor under MoD's Defence Testing Infrastructure Scheme.",
        "Liaise with MGO Branch, Army HQ to issue RFPs/EoIs to CODISSIA-registered manufacturers for indigenisation (DGEME) and new supply chain development (DGOS).",
      ],
    },
    {
      title: "TARGET",
      subtitle: "Our implementation goals",
      description:
        "Enable industries in and around Coimbatore to register and participate in MoD tenders issued by Ordnance Factories (OFB) and Defence PSUs (DPSUs).",
    },
    {
      title: "NODAL OFFICER",
      subtitle: "Primary point of contact",
      description: {
        name: "Dr. T. K. Varadarajan",
        role: "SQAO, SQAE (M&E), Aruvankadu, DGQA",
        appointment:
          "Nominated by DG, DGQA to oversee the Facilitation Cell at CODISSIA.",
      },
    },
    {
      title: "SCHEDULE",
      subtitle: "Operational timeline",
      description: [
        "DGQA Facilitation Cell at CODISSIA will be operational 2 days per week (Friday/Saturday of the week). Nodal officer will also be available at the cell on demand/necessity basis.",
        "Meetings on prior registration only.",
        "Interested members kindly drop a mail to info@cdiic.in to register you to participate in the DGQA Facilitation Cell at CODISSIA.",
      ],
    },
  ];

  const renderContent = () => {
    const item = data[activeIndex];
    return (
      <div className="data-section">
        <h3 className="section-title-custom">{item.title}</h3>
        {Array.isArray(item.description) ? (
          <ul className="description-list">
            {item.description.map((point, i) => (
              <li key={i}>{point}</li>
            ))}
          </ul>
        ) : typeof item.description === "object" ? (
          <div className="description-object">
            <p>
              <strong>Name:</strong> {item.description.name}
            </p>
            <p>
              <strong>Role:</strong> {item.description.role}
            </p>
            <p>
              <strong>Appointment:</strong> {item.description.appointment}
            </p>
          </div>
        ) : (
          <p className="description-text">{item.description}</p>
        )}
      </div>
    );
  };

  return (
    <div className="indigenisation-container sec-ptb">
      <div className="container">
        <div className="sec-content  text-center  mb-5">
            <h6 className="sec-sub-title">Our Goals</h6>
            <h2 className="teamx-title text-white ">Explore What's Our Goals</h2>
          </div>
        <div className="row">
          <div className="col-lg-6">
            <div className="header-block-main indigenisation-container-sutom">
              <div className="nav-items">
                {data.map((item, index) => (
                  <div
                    key={index}
                    className={`nav-item-custom d-flex justify-content-between ${
                      activeIndex === index ? "active" : ""
                    }`}
                    onMouseEnter={() => setActiveIndex(index)}
                    onClick={() => setActiveIndex(index)}
                  >
                    <div>
                      <h4 className="nav-title-custom">{item.title}</h4>
                      <p className="nav-subtitle-custom">{item.subtitle}</p>
                    </div>
                    <div className="bg-go">
                        <GoChevronRight/>
                    </div>
                  </div>
                ))}
              </div>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="content-block">{renderContent()}</div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default IndigenisationAddition;
