import React from "react";
import {
  Container,
  Card,
  Accordion,
  Button,
  ListGroup,
  Badge,
} from "react-bootstrap";
import {
  FaShieldAlt,
  FaIndustry,
  FaCalendarAlt,
  FaEnvelope,
  FaHandsHelping,
} from "react-icons/fa";

const IndigenisationInfo = () => {
  return (
    <div className="dgqa-super-container py-5">
      <Container>
        <div className="dgqa-super-container py-5">
          <Container className="mb-5">
            <div className="row">
              <div className="col-md-6">
                <div className="sec-content    mb-3">
                  <h6 className="sec-sub-title">Indigenisation</h6>
                  <h2 className="teamx-title ">
                    India’s First Defence Innovation Hub
                  </h2>
                </div>
                <div className="col-12 ">
                  <div>
                    <p>
                      Taking a step forward to boost indigenous production of
                      defence equipment, the then Defence Minister, Smt. Nirmala
                      Sitharaman, inaugurated the Tamil Nadu Defence Industrial
                      Corridor on Sunday, 20th January, 2019, at Trichy. The
                      Tamil Nadu Defence Industrial Corridor — also called the
                      Tamil Nadu Defence Production Quad as the nodal cities
                      form a quadrilateral with one of them at the centre —
                      includes Chennai, Hosur, Salem, Coimbatore and
                      Tiruchirappalli as nodes.
                    </p>

                    <p>
                      Following this announcement, CODISSIA was awarded the
                      prestigious opportunity of being the ‘First Defence
                      Innovation Hub’ in India. This led to the incorporation of
                      CDIIC – CODISSIA Defence Innovation and Atal Incubation
                      Centre.
                    </p>
                  </div>
                </div>
              </div>
              <div className="col-md-6">
                    <div className="col-12 text-center">
                <div>
                  <img
                    className="img-fluid"
                    src="/images/Indigenisation/Indigenisation.jpg"
                    alt=""
                    srcset=""
                  />
                  <p className="fw-bold mt-3">
                    We are glad to announce that this centre has started its
                    functions towards all indigenisation activities from 1st
                    June, 2020.
                  </p>
                </div>
              </div>
              </div>
            </div>
          </Container>
          <Container>
            <div className="row">
          
            </div>
          </Container>
        </div>
        <div>
          <div className="sec-content  text-center  mb-5">
            <h6 className="sec-sub-title">SOP</h6>
            <h2 className="teamx-title ">STANDARD OPERATING PROCEDURE (SOP)</h2>
          </div>
        </div>
        <div className="process-wrapper">
          <div className="process-flow">
            <div className="process-step">
              <div className="step-badge">01</div>
              <h3>Planning</h3>
              <p>
                List of items for indigenisation will be shared with all
                Regional MSMEs.
              </p>
            </div>
            <div className="arrow-line" />
            <div className="process-step">
              <div className="step-badge">02</div>
              <h3>Product Identification</h3>
              <p>
                Companies identify products they can indigenise and inform
                CDIIC/DGQA.
              </p>
            </div>
            <div className="arrow-line" />
            <div className="process-step">
              <div className="step-badge">03</div>
              <h3>Capability Assessment</h3>
              <p>
                On-site evaluation to assess firm’s capabilities and potential.
              </p>
            </div>

            <div className="process-step">
              <div className="step-badge">04</div>
              <h3>DGQA Registration</h3>
              <p>
                Company registers with DGQA following guidance from Nodal
                Officer.
              </p>
            </div>
            <div className="arrow-line" />
            <div className="process-step">
              <div className="step-badge">05</div>
              <h3>Proposal Submission</h3>
              <p>
                Submit project proposal for approval by the procurement agency.
              </p>
            </div>
            <div className="arrow-line" />
            <div className="process-step">
              <div className="step-badge">06</div>
              <h3>Prototype Validation</h3>
              <p>
                Prototype validation and support for eventual supply of
                indigenised items.
              </p>
            </div>
          </div>
        </div>
      </Container>
    </div>
  );
};

export default IndigenisationInfo;
