import React, { useContext } from "react";
import { Container, Form, Button, Row, Col } from "react-bootstrap";
import { PropsContext } from "../../../context/PropsContext";

import { FiChevronsRight } from "react-icons/fi";
import Video from "../video/Video";

export default function LatestBlog() {
  const {
    contactData,
    contactErrors,
    isSubmitting,
    submitSuccess,
    contactDatahandleChange,
    contactDatahandleSubmit,
  } = useContext(PropsContext);

  return (
    <section className="blog-sec sec-ptb">
      <div className="container">
        <div className="row align-items-center justify-content-center explore-form-main">
          {/* Left Content */}
          <div className="col-lg-6 col-md-8 mb-4 mb-lg-0">
            <div className="sec-content text-white">
              <p className="text-uppercase text-info small mb-2">
                Start up business
              </p>
              <div className="sec-title">
                  <h2 className=" mb-3">
                Experience The Evolution <br /> Of Your Business
              </h2>
              </div>
            
              <p className="mb-4">
                Our world is changing, and so is your business. To stay relevant
                and successful, you need to evolve.
              </p>
              <div className="d-flex video-btn-main align-items-center gap-3 mb-4">
                <Video />
                <div>
                  {" "}
                  <h4>Watch Consulting Video</h4>
                </div>
              </div>
            </div>
          </div>

          {/* Right Form */}
          <div className="col-lg-6 col-md-8 mb-4 mb-lg-0">
            <div className="dihub-super-container">
                 <Container>
                   
           
                   <Row className="justify-content-center">
                     <Col lg={12}>
                       <div className="dihub-form-container-blog ">
                      
                         <Form onSubmit={contactDatahandleSubmit}>
                            <div>
                          <h5 className="mb-4">Get In Touch</h5>

                        </div>
                           <Row>
                             <Col md={12}>
                               <Form.Group className="mb-4 dihub-form-group">
                               
                                 <Form.Control
                                   type="text"
                                   name="name"
                                   value={contactData.name}
                                   onChange={contactDatahandleChange}
                                   placeholder="Full Name"
                                   className={`dihub-input-blog ${
                                     contactErrors.name ? "is-invalid" : ""
                                   }`}
                                 />
                                 {contactErrors.name && (
                                   <div className="invalid-feedback">
                                     {contactErrors.name}
                                   </div>
                                 )}
                               </Form.Group>
                             </Col>
                           </Row>
           
                           <Row>
                             <Col md={12}>
                               <Form.Group className="mb-4 dihub-form-group">
                              
                                 <Form.Control
                                   type="email"
                                   name="email"
                                   value={contactData.email}
                                   onChange={contactDatahandleChange}
                                   placeholder="Email Address"
                                   className={`dihub-input-blog ${
                                     contactErrors.email ? "is-invalid" : ""
                                   }`}
                                 />
                                 {contactErrors.email && (
                                   <div className="invalid-feedback">
                                     {contactErrors.email}
                                   </div>
                                 )}
                               </Form.Group>
                             </Col>
                           </Row>
           
                           <Row>
                             <Col md={12}>
                               <Form.Group className="mb-4 dihub-form-group">
                                
                                 <Form.Control
                                   type="text"
                                   name="phone"
                                   value={contactData.phone}
                                   onChange={contactDatahandleChange}
                                   placeholder="Enter Phone"
                                   className={`dihub-input-blog ${
                                     contactErrors.phone ? "is-invalid" : ""
                                   }`}
                                 />
                                 {contactErrors.phone && (
                                   <div className="invalid-feedback">
                                     {contactErrors.phone}
                                   </div>
                                 )}
                               </Form.Group>
                             </Col>
           
                             <Col md={12}>
                               <Form.Group className="mb-4 dihub-form-group">
                                
                                 <Form.Control
                                   as="textarea"
                                   name="message"
                                   rows={4}
                                   value={contactData.message}
                                   onChange={contactDatahandleChange}
                                   placeholder="Message"
                                   className={`dihub-input-blog ${
                                     contactErrors.message ? "is-invalid" : ""
                                   }`}
                                 />
                                 {contactErrors.message && (
                                   <div className="invalid-feedback">
                                     {contactErrors.message}
                                   </div>
                                 )}
                               </Form.Group>
                             </Col>
                           </Row>
           
                           <div className="text-center">
                             <Button
                               variant="primary"
                               type="submit"
                               className="dihub-submit-btn"
                               disabled={isSubmitting}
                             >
                               {isSubmitting ? "Submitting..." : "Send Message"}
                             </Button>
                           </div>
           
                           {submitSuccess && (
                             <div className="alert alert-success mt-3">
                               Your message has been submitted successfully!
                             </div>
                           )}
                         </Form>
                       </div>
                     </Col>
                   </Row>
                 </Container>
               </div>
          </div>
        </div>
      </div>
    </section>
  );
}
