import React, { useState } from "react";
import { Container, Form, Button, Row, Col } from "react-bootstrap";

const LoginForm = () => {
  const [isLogin, setIsLogin] = useState(true);

  const toggleForm = () => setIsLogin(!isLogin);

  return (
    <>
      <section
        id="site-breadcumb"
        style={{
          backgroundImage: "url(/images/subanner/subanner.jpg)",
        }}
      >
        <div className="site-breadcumb-wrapper">
          <div className="container">
            <div className="row">
              <div className="col">
                <div className="breadcumb-content">
                  <h1 className="breadcumb-title">Home</h1>
                  
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section >
        <div className="dihub-super-container-section sec-ptb ">
          <Container>
            <div className="mb-5 text-center">
              <h6 className="sec-sub-title">
                {isLogin ? "Welcome Back" : "Join Us"}
              </h6>
              <h2 className="teamx-title">
                {isLogin
                  ? "Log in to your account to access your preferences"
                  : "Create an account to get started"}
              </h2>
            </div>

            <Row className="align-items-center dihub-super-container-main ">
              {/* Left side with toggle text */}
              <Col
                lg={6}
                className="text-center text-lg-start mb-4 mb-lg-0 dihub-form-container-left"
              >
                <div className="dihub-create-account">
                  <h3>{isLogin ? "New here?" : "Already have an account?"}</h3>
                  <p>
                    {isLogin
                      ? "Create an account to start exploring our services."
                      : "Log in to your existing account to continue."}
                  </p>

                  <div className="btn-download ">
                    <a href="#" onClick={toggleForm}>
                      {isLogin ? "Create an Account" : "Back to Login"}
                    </a>
                  </div>
                </div>
              </Col>

              {/* Right side with form */}
              <Col lg={6} className="dihub-form-container-right ">
                <div>
                  <div
                    className="dihub-form-container p-3 w-100"
                    
                  >
                    <Form>
                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Email <span className="dihub-">*</span>
                        </Form.Label>
                        <Form.Control
                          type="email"
                          name="email"
                          placeholder="Enter your email"
                          className="dihub-input"
                        />
                      </Form.Group>

                      {!isLogin && (
                        <Form.Group className="mb-4 dihub-form-group">
                          <Form.Label className="dihub-label">
                            Name <span className="dihub-">*</span>
                          </Form.Label>
                          <Form.Control
                            type="text"
                            name="name"
                            placeholder="Enter your name"
                            className="dihub-input"
                          />
                        </Form.Group>
                      )}

                      <Form.Group className="mb-4 dihub-form-group">
                        <Form.Label className="dihub-label">
                          Password <span className="dihub-">*</span>
                        </Form.Label>
                        <Form.Control
                          type="password"
                          name="password"
                          placeholder="Enter your password"
                          className="dihub-input"
                        />
                      </Form.Group>

                      {!isLogin && (
                        <Form.Group className="mb-4 dihub-form-group">
                          <Form.Label className="dihub-label">
                            Confirm Password <span className="dihub-">*</span>
                          </Form.Label>
                          <Form.Control
                            type="password"
                            name="confirmPassword"
                            placeholder="Confirm your password"
                            className="dihub-input"
                          />
                        </Form.Group>
                      )}

                      <div className="btn-download ">
                        <a href="#" onClick={toggleForm} type="submit">
                          {isLogin ? "Log In" : "Create Account"}
                        </a>
                      </div>
                    </Form>
                  </div>
                </div>
              </Col>
            </Row>
          </Container>
        </div>
      </section>
    </>
  );
};

export default LoginForm;
