import React from "react";


const programData = [
  {
    title: "CDIIC Startup Challenge",
    desc: "A competition to showcase innovative solutions by startups.",
    img: "/images/programs/1.png"
  },
  {
    title: "CDIIC Startup Meetings",
    desc: "Networking events for startups and investors.",
       img: "/images/programs/2.png"
  },
  {
    title: "CDIIC Pitch Fest",
    desc: "Pitch your ideas to leading investors and VCs.",
      img: "/images/programs/3.png"
  },
  {
    title: "Trainings",
    desc: "Skill enhancement programs by industry experts.",
    img: "/images/programs/4.png"
  },
  {
    title: "Workshops",
    desc: "Hands-on sessions on latest technologies.",
    img: "/images/programs/5.png"
  },
  {
    title: "Seminars",
    desc: "Knowledge sharing forums by thought leaders.",
       img: "/images/programs/6.png"
  }
];

const Programschedule = () => {
  return (
    <section className="program-container">
      <div className="container">
        <div className="sec-content text-center mb-5">
              <h6 className="sec-sub-title">Our Programs</h6>
              <h2 className="sec-title">Explore Our Programs</h2>
            </div>
        <div className="row">
          {programData.map((item, index) => (
            <div className="col-lg-4 col-md-6 mb-4" key={index}>
              <div className="program-card-box">
                <div className="program-img">
                  <img src={item.img} alt={item.title} />
                </div>
                <div className="program-content">
                  <h4>{item.title}</h4>
                  <p>{item.desc}</p>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default Programschedule;
