import { useEffect, useRef } from "react";
import { FiChevronsRight } from "react-icons/fi";
import gsap from "gsap";
import { ScrollTrigger } from "gsap/ScrollTrigger";

import "swiper/css";
import "swiper/css/pagination";

gsap.registerPlugin(ScrollTrigger);

export default function Testimonial() {
  const leftRef = useRef(null);
  const rightRef = useRef(null);

  useEffect(() => {
    gsap.fromTo(
      leftRef.current,
      {
        clipPath: "inset(100% 0 0 0)",
        opacity: 0,
      },
      {
        clipPath: "inset(0% 0 0 0)",
        opacity: 1,
        duration: 2.8,
        ease: "power2.out",
        scrollTrigger: {
          trigger: leftRef.current,
          start: "top bottom", // animation starts when top of element hits bottom of viewport
          toggleActions: "play none none none",
          // markers: true,      // uncomment to debug trigger position
        },
      }
    );

    gsap.fromTo(
      rightRef.current,
      {
        clipPath: "inset(0 0 100% 0)",
        opacity: 0,
      },
      {
        clipPath: "inset(0 0 0% 0)",
        opacity: 1,
        duration: 2.8,
        ease: "power2.out",
        scrollTrigger: {
          trigger: rightRef.current,
          start: "top bottom",
          toggleActions: "play none none none",
          // markers: true,
        },
      }
    );
  }, []);

  return (
    <section className="testimonial-sec sec-ptb">
      <div className="container">
        <div className="row">
          <div className="col-lg-6 mb-4" ref={leftRef}>
            <div className="about-container">
              <div className="background-img">
                <img
                  src="/images/home/organization-main.png"
                  alt="Building"
                  className="background-img-img img-fluid h-100 w-100 object-cover"
                />
                <div className="overlay-img">
                  <img src="/images/home/organization-main-2.png" alt="Team" />
                </div>
              </div>
            </div>
          </div>

          <div className="col-lg-6 organisation-content" ref={rightRef}>
            <div>
              <div className="sec-title">
                <h2>Parent Organisation of CDIIC</h2>
              </div>
              <p>
                CODISSIA - The Coimbatore District Small Industries Association
                - is one of the largest Association for Micro, Small and Medium
                Enterprises in India, having come a long way since its inception
                in the year 1969, with about 40 members, today CODISSIA is
                having more than 6600 members from different sectors. CODISSIA
                is celebrating its Golden Jubilee Year with NABET Accreditation.
              </p>

              <p>
                CODISSIA has been consistently organizing Entrepreneur
                Development Program on all Fridays, since the past 40 years,
                without any break. It gives counselling to budding as well as
                existing entrepreneurs, provides necessary hand holding, assist
                them in getting loans, suggests ways and means to successfully
                market their product, monitor their progress,
              </p>

              <div className="btn-download mt-4">
                <a href="#">
                  More{" "}
                  <span className="ps-5">
                    {" "}
                    <FiChevronsRight />{" "}
                  </span>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
