import { Link } from "react-router-dom";

const socials = [
  {
    icon: "fa-brands fa-facebook-f",
    link: "https://www.facebook.com/",
  },
  {
    icon: "fa-brands fa-linkedin-in",
    link: "https://www.linkedin.com/",
  },
  {
    icon: "fa-brands fa-twitter",
    link: "https://twitter.com/",
  },
  {
    icon: "fa-brands fa-instagram",
    link: "https://www.instagram.com/",
  },
];

export default function GetTouch() {
  return (
    <div className="sec-content get-in-touch-info">
      <h4 className="mb-3">Hi! We are always here to help you.</h4>
      <div className="get-in-touch">
        {/* project-qinfo */}
        <div className="qinfo-item">
          {/* qinfo-item-1 */}
          <div className="qinfo-icon">
            <i className="flaticon-maps-and-flags" />
          </div>
          <div className="qinfo-box">
            <h5>Location</h5>
            <Link to="/">
              CODISSIA Defence Innovation and Atal Incubation Centre (CDIIC), PB
              No: 3827, Huzur Road, Coimbatore - 641018
            </Link>
          </div>
        </div>
        <div className="qinfo-item">
          {/* qinfo-item-2 */}
          <div className="qinfo-icon">
            <i className="flaticon-call" />
          </div>
          <div className="qinfo-box">
            <h5>Call Now</h5>
            <Link to="tel:0422 222 1582">0422 222 1582</Link>
          </div>
        </div>
        <div className="qinfo-item mb-0">
          {/* qinfo-item-3 */}
          <div className="qinfo-icon">
            <i className="flaticon-gmail-logo" />
          </div>
          <div className="qinfo-box">
            <h5>Email Us</h5>
            <Link to="mailto:info@cdiic.in">info@cdiic.in</Link>
          </div>
        </div>
      </div>
      <hr />
      <div className="company-social d-flex justify-content-center">
        {/* social part start */}
        {socials.map((item, i) => (
          <Link key={i} to={item.link} target="_blank">
            <i className={item.icon} />
          </Link>
        ))}
        {/* social part end */}
      </div>
    </div>
  );
}
