import { useParams } from "react-router-dom";
import { useContext } from "react";
import { PropsContext } from "../../../context/PropsContext";

export default function NewsGalleryDetail() {
  const { id } = useParams();
  const { formattedNewsGallery } = useContext(PropsContext);

  // Show loading while context data is still fetching
  if (!formattedNewsGallery || formattedNewsGallery.length === 0) {
    return (
      <div className="text-center py-5">
        <h2>Loading Gallery...</h2>
      </div>
    );
  }

  const galleryItem = formattedNewsGallery.find(
    (item) => item.id.toString() === id
  );

  if (!galleryItem) {
    return (
      <div className="text-center py-5">
        <h2>Gallery Item Not Found</h2>
      </div>
    );
  }

  return (
    <section className="news-gallery-detail py-5">
      <div className="container">
        <h2 className="text-center mb-4">{galleryItem.title}</h2>

        <div className="row">
          {galleryItem.images && galleryItem.images.length > 0 ? (
            galleryItem.images.map((imgUrl, index) => (
              <div className="col-md-4 mb-4" key={index}>
                <img
                  src={imgUrl}
                  alt={`Gallery ${index + 1}`}
                  className="img-fluid rounded shadow"
                  style={{ height: "250px", objectFit: "cover", width: "100%" }}
                  onError={(e) => {
                    e.target.onerror = null;
                    e.target.src = "https://placehold.co/400x250?text=No+Image";
                  }}
                />
              </div>
            ))
          ) : (
            <p className="text-center">No additional images available.</p>
          )}
        </div>
      </div>
    </section>
  );
}
