import "swiper/css";
import "swiper/css/navigation";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
import { accounts, designers } from "../../../data/site";

export default function TeamOthers() {
  return (
    <>
      <section className="team-others-section">
        <div className="team-others-container">
          <div className="team-others-header text-center mb-5">
            <h6 className="sec-sub-title">
              Our Designer and Accounts
            </h6>
            <h2 className="teamx-title">
              Creative minds shaping our brand with innovation and style. 
            </h2>
          </div>
          <div className="team-others-row">
            <div className="team-others-col-lg-8 mb-3">
              <div className="team-others-carousel-wrapper-left">
                <Swiper
                  spaceBetween={30}
                  navigation={{
                    nextEl: ".team-others-nav-next-left",
                    prevEl: ".team-others-nav-prev-left",
                  }}
                  modules={[Navigation]}
                  breakpoints={{
                    0: { slidesPerView: 1 },
                    425: { slidesPerView: 1 },
                    767: { slidesPerView: 2 },
                    992: { slidesPerView: 2 },
                  }}
                  loop={true}
                >
                  {designers.map((item, i) => (
                    <SwiperSlide key={i}>
                      <div className="team-others-partner-card">
                        <img
                          src={item.imgUrl}
                          alt={item.imgUrl}
                          className="team-others-partner-image"
                        />
                        <h4 className="team-others-partner-name">
                          {item.title}
                        </h4>
                        <p className="team-others-partner-description">
                          {item.des}
                        </p>
                      </div>
                    </SwiperSlide>
                  ))}
                </Swiper>

                <div className="team-others-navigation-left">
                  <button className="team-others-nav-prev-left">
                    <i className="flaticon-left-arrow" />
                  </button>
                  <button className="team-others-nav-next-left">
                    <i className="flaticon-right-arrow" />
                  </button>
                </div>
              </div>
            </div>
            <div className="team-others-col-lg-4">
              <div className="team-others-carousel-wrapper-right">
                <Swiper
                  spaceBetween={10}
                  navigation={{
                    nextEl: ".team-others-nav-next-right",
                    prevEl: ".team-others-nav-prev-right",
                  }}
                  modules={[Navigation]}
                  breakpoints={{
                    0: { slidesPerView: 1 },
                    425: { slidesPerView: 1 },
                    767: { slidesPerView: 1 },
                    992: { slidesPerView: 1 },
                  }}
                  loop={true}
                >
                  {accounts.map((item, i) => (
                    <SwiperSlide key={i}>
                      <div className="team-others-partner-card">
                        <img
                          src={item.imgUrl}
                          alt={item.imgUrl}
                          className="team-others-partner-image"
                        />
                        <h4 className="team-others-partner-name">
                          {item.title}
                        </h4>
                        <p className="team-others-partner-description">
                          {item.des}
                        </p>
                      </div>
                    </SwiperSlide>
                  ))}
                </Swiper>

                <div className="team-others-navigation-right">
                  <button className="team-others-nav-prev-right">
                    <i className="flaticon-left-arrow" />
                  </button>
                  <button className="team-others-nav-next-right">
                    <i className="flaticon-right-arrow" />
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      {/* Psg Step */}
    </>
  );
}