import { createContext, useState, useMemo, useEffect, useRef } from "react";
import apiService, { storage } from "../services/apiServices";
import { FaMapMarkerAlt, FaCalendarAlt, FaTag } from "react-icons/fa";
import { toast } from "react-toastify";

export const PropsContext = createContext();

export const PropsProvider = ({ children }) => {
  const [galleryData, setGalleryData] = useState([]);
  const [newsGalleryData, setNewsGalleryData] = useState([]);

const [newsGalleryDetail, setNewsGalleryDetail] = useState(null);

  const [eventsData, setEventsData] = useState([]);
  const [announcementsData, setAnnouncementsData] = useState([]);
  const [tendersData, setTendersData] = useState([]);
  const [applicationData, setApplicationData] = useState([]);
  const [bannerData, setBannerData] = useState([]);

  
  const nextSectionRef = useRef(null);
  const [subscriberDatasubscriberData, setsubscriberData] = useState({
    email: "",
  });

  const [subscriberDataerrors, setsubscriberDataErrors] = useState({});

  const [subscriberDataSuccess, setsubscriberDataSuccess] = useState(false);

  const [indigenisationformData, setIndigenisationformData] = useState({
    name: "",
    email: "",
    phone: "",
    organisation: "",
    designation: "",
  });

  const [indigenisationformerrors, setindigenisationformErrors] = useState({});
  const [isindigenisationformSubmitting, setIsindigenisationformSubmitting] =
    useState(false);
  const [isindigenisationformSuccess, setIsindigenisationformSuccess] =
    useState(false);

  const [contactData, setContactData] = useState({
    firstName: "",
    lastName: "",
    email: "",
    subject: "",
    message: "",
  });

  const [contactErrors, setContactErrors] = useState({});
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [submitSuccess, setSubmitSuccess] = useState(false);

  const subscriberDatahandleChange = (e) => {
    const { name, value } = e.target;
    setIndigenisationformData((prev) => ({
      ...prev,
      [name]: value,
    }));

    if (indigenisationformerrors[name]) {
      // Changed from errors to indigenisationformerrors
      setindigenisationformErrors((prev) => ({
        ...prev,
        [name]: null,
      }));
    }
  };

  const subscriberDataSubmit = async (e) => {
    e.preventDefault();
    setsubscriberDataErrors({});
    setsubscriberDataSuccess(false);

    try {
      const response = await apiService.post(
        "subscriber",
        subscriberDatasubscriberData
      );

      if (response.data?.message) {
        setsubscriberData({ email: "" });
        setsubscriberDataSuccess(true);

        toast.success(response.data.message, {
          position: "top-right",
          autoClose: 3000,
        });

        setTimeout(() => setsubscriberDataSuccess(false), 3000);
      } else {
        throw new Error(response.data?.message || "Submission failed.");
      }
    } catch (error) {
      console.error("Newsletter submission error:", error);

      if (error.response?.data?.errors) {
        const apiErrors = error.response.data.errors;
        const formattedErrors = {};
        Object.keys(apiErrors).forEach((key) => {
          formattedErrors[key] = apiErrors[key][0];
        });
        setsubscriberDataErrors(formattedErrors);

        toast.error("Please correct the form errors", {
          position: "top-right",
          autoClose: 5000,
        });
      } else {
        toast.error(
          error.message || "Something went wrong. Please try again.",
          {
            position: "top-right",
            autoClose: 5000,
          }
        );
      }
    }
  };

  const indigenisationhandleChange = (e) => {
    const { name, value } = e.target;
    setIndigenisationformData((prev) => ({
      ...prev,
      [name]: value,
    }));

    if (indigenisationformerrors[name]) {
      // Changed from errors to indigenisationformerrors
      setindigenisationformErrors((prev) => ({
        ...prev,
        [name]: null,
      }));
    }
  };

  const indigenisationhandleSubmit = async (e) => {
    e.preventDefault();
    setindigenisationformErrors({});
    setIsindigenisationformSubmitting(true);

    try {
      const response = await apiService.post(
        "indigenisation",
        indigenisationformData
      );
      if (response.data) {
        // Reset form only after successful submission
        setIndigenisationformData({
          name: "",
          email: "",
          phone: "",
          organisation: "",
          designation: "",
        });

        setIsindigenisationformSuccess(true);

        toast.success(response.data, {
          position: "top-right",
          autoClose: 3000,
          hideProgressBar: false,
          closeOnClick: true,
          pauseOnHover: true,
          draggable: true,
          progress: undefined,
        });

        // Reset success status after some time
        setTimeout(() => {
          setIsindigenisationformSuccess(false);
        }, 3000);
      } else {
        throw new Error(response.data?.message || "Failed to send message");
      }
    } catch (error) {
      console.error("Submission error:", error);

      if (error.response?.data?.errors) {
        const apiErrors = error.response.data.errors;
        const formattedErrors = {};
        Object.keys(apiErrors).forEach((key) => {
          formattedErrors[key] = apiErrors[key][0];
        });
        setindigenisationformErrors(formattedErrors);

        toast.error("Please correct the form errors", {
          position: "top-right",
          autoClose: 5000,
        });
      } else {
        toast.error(
          error.message || "Failed to send message. Please try again.",
          {
            position: "top-right",
            autoClose: 5000,
          }
        );
      }
    } finally {
      setIsindigenisationformSubmitting(false);
    }
  };

  const contactDatahandleChange = (e) => {
    const { name, value } = e.target;
    setContactData((prev) => ({
      ...prev,
      [name]: value,
    }));

    if (contactErrors[name]) {
      setContactErrors((prev) => ({
        ...prev,
        [name]: null,
      }));
    }
  };

  const contactDatahandleSubmit = async (e) => {
    e.preventDefault();
    setContactErrors({});
    setIsSubmitting(true);

    try {
      const response = await apiService.post("contact", contactData);

      if (response.data) {
        // Reset form only after successful submission
        setContactData({
          name: "",
          email: "",
          phone:"",
          subject: "",
          message: "",
        });

        setSubmitSuccess(true);

        toast.success(response.data, {
          position: "top-right",
          autoClose: 3000,
          hideProgressBar: false,
          closeOnClick: true,
          pauseOnHover: true,
          draggable: true,
          progress: undefined,
        });

        // Reset success status after some time
        setTimeout(() => {
          setSubmitSuccess(false);
        }, 3000);
      } else {
        throw new Error(response.data?.message || "Failed to send message");
      }
    } catch (error) {
      console.error("Submission error:", error);

      if (error.response?.data?.errors) {
        const apiErrors = error.response.data.errors;
        const formattedErrors = {};
        Object.keys(apiErrors).forEach((key) => {
          formattedErrors[key] = apiErrors[key][0];
        });
        setContactErrors(formattedErrors);

        toast.error("Please correct the form errors", {
          position: "top-right",
          autoClose: 5000,
        });
      } else {
        toast.error(
          error.message || "Failed to send message. Please try again.",
          {
            position: "top-right",
            autoClose: 5000,
          }
        );
      }
    } finally {
      setIsSubmitting(false);
    }
  };

  const fetchNewsGalleryDetailById = async (id) => {
  try {
    console.log(id);
    const res = await apiService.get(`ngdetails?id=${id}`);
    if (res?.data) {
      return res.data;
    }
  } catch (err) {
    console.error(`News Gallery detail fetch error for id=${id}:`, err);
    return null;
  }
};


  // banner skip
  const handleScrollClick = () => {
    if (nextSectionRef.current) {
      nextSectionRef.current.scrollIntoView({
        behavior: "smooth",
      });
    }
  };

  const [galleryPagination, setGalleryPagination] = useState({
    current_page: 1,
    last_page: 1,
  });
  const [newsGalleryPagination, setNewsGalleryPagination] = useState({
    current_page: 1,
    last_page: 1,
  });
  const [eventsPagination, setEventsPagination] = useState({
    current_page: 1,
    last_page: 1,
  });
  const [announcementsPagination, setAnnouncementsPagination] = useState({
    current_page: 1,
    last_page: 1,
  });
  const [tendersPagination, setTendersPagination] = useState({
    current_page: 1,
    last_page: 1,
  });
  const [applicationPagination, setApplicationPagination] = useState({
    current_page: 1,
    last_page: 1,
  });

  const fetchGalleryData = async (page = 1) => {
    try {
      const res = await apiService.get(`gallery?page=${page}`);
      if (res && res.data) {
        setGalleryData(res.data.data || []);
        setGalleryPagination({
          current_page: res.data.current_page,
          last_page: res.data.last_page,
        });
      }
    } catch (err) {
      console.error("Gallery fetch error:", err);
    }
  };

  const fetchNewsGalleryData = async (page = 1) => {
    try {
      const res = await apiService.get(`ngallery?page=${page}`);
      if (res && res.data) {
        setNewsGalleryData(res.data.data || []);
        setNewsGalleryPagination({
          current_page: res.data.current_page,
          last_page: res.data.last_page,
        });
      }
   
    } catch (err) {
      console.error("News Gallery fetch error:", err);
    }
  };

  const fetchEventsData = async (page = 1) => {
    try {
      const res = await apiService.get(`event?page=${page}`);
      if (res && res.data) {
        setEventsData(res.data.data || []);
        setEventsPagination({
          current_page: res.data.current_page,
          last_page: res.data.last_page,
        });
      }
    } catch (err) {
      console.error("Events fetch error:", err);
    }
  };

  const fetchAnnouncementsData = async (page = 1) => {
    try {
      const res = await apiService.get(`announcement?page=${page}`);
      if (res && res.data) {
        setAnnouncementsData(res.data.data || []);
        setAnnouncementsPagination({
          current_page: res.data.current_page,
          last_page: res.data.last_page,
        });
      }
    } catch (err) {
      console.error("Announcements fetch error:", err);
    }
  };

  const fetchTendersData = async (page = 1) => {
    try {
      const res = await apiService.get(`tender?page=${page}`);
      if (res && res.data) {
        setTendersData(res.data.data || []);
        setTendersPagination({
          current_page: res.data.current_page,
          last_page: res.data.last_page,
        });
      }
    } catch (err) {
      console.error("Tenders fetch error:", err);
    }
  };

  const fetchApplicationData = async (page = 1) => {
    try {
      const res = await apiService.get(`application?page=${page}`);
      if (res && res.data) {
        setApplicationData(res.data.data || []);
        setApplicationPagination({
          current_page: res.data.current_page,
          last_page: res.data.last_page,
        });
      }
    } catch (err) {
      console.error("Application fetch error:", err);
    }
  };

  const fetchBannerData = async () => {
    try {
      const res = await apiService.get("banner");
      if (res && res.data) {
        setBannerData(res.data.data || []);
      }
    } catch (err) {
      console.error("Application fetch error:", err);
    }
  };

  // Format application data
  const formattedApplications = useMemo(() => {
    if (!Array.isArray(applicationData)) return [];
    return applicationData.map((item) => ({
      id: item.id,
      title: item.title || "No title available",
      pdfUrl: item.pdf_path ? `${storage}/${item.pdf_path}` : null,
      createdAt: new Date(item.created_at).toLocaleDateString("en-US", {
        year: "numeric",
        month: "short",
        day: "numeric",
      }),
    }));
  }, [applicationData, storage]);

  useEffect(() => {
    fetchGalleryData();
    fetchNewsGalleryData();
    fetchEventsData();
    fetchAnnouncementsData();
    fetchTendersData();
    fetchApplicationData();
  }, []);

  const formattedGallery = useMemo(() => {
    if (!Array.isArray(galleryData)) return [];
    return galleryData.map((item) => ({
      id: item.id,
      title: item.name || "No title available",
      image: item.image
        ? `${storage}/${item.image}`
        : "/images/default-gallery.jpg",
    }));
  }, [galleryData]);

const formattedNewsGallery = useMemo(() => {
  if (!Array.isArray(newsGalleryData)) return [];
  return newsGalleryData.map((item) => ({
    id: item.id,
    title: item.name || "No title available",
    image: item.image
      ? `${storage}/${item.image}`
      : "https://placehold.co/400x250",
    images: Array.isArray(item.images)
      ? item.images.map((img) => `${storage}/${img.image_path}`)
      : [],
  }));
}, [newsGalleryData]);


  const formattedEvents = useMemo(() => {
    if (!Array.isArray(eventsData)) return [];
    return eventsData.map((item) => {
      const startDate = new Date(item.start_date);
      const endDate = new Date(item.end_date);

      const formatDateRange = (start, end) => {
        if (start.getFullYear() !== end.getFullYear()) {
          return `${start.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
          })} - ${end.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
            year: "numeric",
          })}`;
        }
        if (start.getMonth() !== end.getMonth()) {
          return `${start.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
          })} - ${end.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
          })}, ${start.getFullYear()}`;
        }
        return `${start.toLocaleDateString("en-US", {
          month: "short",
        })} ${start.getDate()}-${end.getDate()}, ${start.getFullYear()}`;
      };

      const formatTimeRange = (start, end) => {
        const formatTime = (timeStr) => {
          const [hours, minutes] = timeStr.split(":");
          const hourNum = parseInt(hours, 10);
          const period = hourNum >= 12 ? "PM" : "AM";
          const displayHour = hourNum % 12 || 12;
          return `${displayHour}:${minutes} ${period}`;
        };
        return `${formatTime(item.start_time)} - ${formatTime(item.end_time)}`;
      };

      return {
        id: item.id,
        date: startDate.getDate().toString().padStart(2, "0"),
        day: startDate.toLocaleDateString("en-US", { weekday: "long" }),
        title: item.title || "No title available",
        subtitle: item.description || "No description available",
        time: formatTimeRange(item.start_time, item.end_time),
        status: item.status || "Not specified",
        image: item.image
          ? `${storage}/${item.image}`
          : "https://placehold.co/400x250",
        credits: [
          {
            icon: <FaMapMarkerAlt className="credit-icon location-icon" />,
            text: item.location || "Venue not specified",
            className: "credit-item location-item",
          },
          {
            icon: <FaCalendarAlt className="credit-icon date-icon" />,
            text: formatDateRange(startDate, endDate),
            className: "credit-item date-item",
          },
          {
            icon: <FaTag className="credit-icon status-icon" />,
            text: `Status: ${item.status || "Not specified"}`,
            className: "credit-item status-item",
          },
        ],
      };
    });
  }, [eventsData, storage]);

  const formattedAnnouncements = useMemo(() => {
    if (!Array.isArray(announcementsData)) return [];
    return announcementsData.map((item) => {
      const startDate = new Date(item.start_date);
      const endDate = new Date(item.end_date);

      const formatDateRange = (start, end) => {
        if (start.getFullYear() !== end.getFullYear()) {
          return `${start.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
          })} - ${end.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
            year: "numeric",
          })}`;
        }
        if (start.getMonth() !== end.getMonth()) {
          return `${start.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
          })} - ${end.toLocaleDateString("en-US", {
            month: "short",
            day: "numeric",
          })}, ${start.getFullYear()}`;
        }
        return `${start.toLocaleDateString("en-US", {
          month: "short",
        })} ${start.getDate()}-${end.getDate()}, ${start.getFullYear()}`;
      };

      return {
        id: item.id,
        title: item.title || "No title available",
        description: item.description || "No description available",
        pdfUrl: item.pdf_path ? `${storage}/${item.pdf_path}` : null,
        dateRange: formatDateRange(startDate, endDate),
        isActive: item.is_active === 1,
        image: item.image
          ? `${storage}/${item.image}`
          : "https://placehold.co/400x250",
        credits: [
          {
            icon: <FaCalendarAlt className="credit-icon date-icon" />,
            text: formatDateRange(startDate, endDate),
            className: "credit-item date-item",
          },
          {
            icon: <FaTag className="credit-icon status-icon" />,
            text: `Status: ${item.is_active === 1 ? "Active" : "Inactive"}`,
            className: "credit-item status-item",
          },
        ],
      };
    });
  }, [announcementsData, storage]);

  const formattedTenders = useMemo(() => {
    if (!Array.isArray(tendersData)) return [];
    return tendersData.map((item) => {
      const noticeDate = new Date(item.notice_date);
      const lastDate = new Date(item.last_date);

      const formatDate = (date) => {
        return date.toLocaleDateString("en-US", {
          year: "numeric",
          month: "short",
          day: "numeric",
        });
      };

      return {
        id: item.id,
        title: item.title || "No title available",
        details: item.details || "No details available",
        pdfUrl: item.pdf_path ? `${storage}/${item.pdf_path}` : null,
        noticeDate: formatDate(noticeDate),
        lastDate: formatDate(lastDate),
        status: item.status || "Not specified",
        credits: [
          {
            icon: <FaCalendarAlt className="credit-icon date-icon" />,
            text: `Notice Date: ${formatDate(noticeDate)}`,
            className: "credit-item date-item",
          },
          {
            icon: <FaCalendarAlt className="credit-icon date-icon" />,
            text: `Last Date: ${formatDate(lastDate)}`,
            className: "credit-item date-item",
          },
          {
            icon: <FaTag className="credit-icon status-icon" />,
            text: `Status: ${item.status || "Not specified"}`,
            className: "credit-item status-item",
          },
        ],
      };
    });
  }, [tendersData, storage]);

  const value = {
    apiService,
    storage,
    formattedGallery,
    formattedNewsGallery,
    formattedEvents,
    formattedAnnouncements,
    formattedTenders,
    formattedApplications,
    galleryPagination,
    newsGalleryPagination,
    eventsPagination,
    announcementsPagination,
    tendersPagination,
    applicationPagination,
    fetchGalleryData,
    fetchNewsGalleryData,
    fetchEventsData,
    fetchAnnouncementsData,
    fetchTendersData,
    fetchApplicationData,
    handleScrollClick,
    nextSectionRef,
    fetchBannerData,
    // Indigensation

    // Add these indigenisation-related states and functions
    indigenisationformData,
    indigenisationformerrors,
    isindigenisationformSubmitting,
    isindigenisationformSuccess,
    indigenisationhandleChange,
    indigenisationhandleSubmit,
    setIndigenisationformData,
    setindigenisationformErrors,
    setIsindigenisationformSubmitting,
    setIsindigenisationformSuccess,
    // Contact Form
    contactData,
    setContactData,
    contactErrors,
    setContactErrors,
    isSubmitting,
    setIsSubmitting,
    submitSuccess,
    setSubmitSuccess,
    contactDatahandleChange,
    contactDatahandleSubmit,

    // Subscribe

    subscriberDatasubscriberData,
    setsubscriberData,
    subscriberDataerrors,
    setsubscriberDataErrors,
    subscriberDataSuccess,
    setsubscriberDataSuccess,
    subscriberDatahandleChange,
    subscriberDataSubmit,
   fetchNewsGalleryDetailById
  };

  return (
    <PropsContext.Provider value={value}>{children}</PropsContext.Provider>
  );
};

export default PropsProvider;
