import IndigenisationAddition from "../../components/sections/indigenisation/IndigenisationAddition";
import IndigenisationForm from "../../components/sections/indigenisation/IndigenisationForm";
import IndigenisationInfo from "../../components/sections/indigenisation/IndigenisationInfo";
import IndigenisationPoints from "../../components/sections/indigenisation/IndigenisationPoints";
import BreadCrumb from "../../components/ui/breadCrumb/BreadCrumb";
import { projects_2 } from "../../data/site";

const breadcumb_data = {
  title: "Indigenisation",
  list: [
    {
      name: "Home",
      url: "/",
    },
    {
      name: "Indigenisation",
      url: "/indigenisation",
    },
  ],
};

export default function ProjectsPage() {
  const data = projects_2.slice(0, 6);
  return (
    <>
      <BreadCrumb data={breadcumb_data} />
      <IndigenisationInfo data={data} />
      <IndigenisationPoints />
      <IndigenisationForm />

      <IndigenisationAddition />
    </>
  );
}
