import { useEffect } from "react";
import AOS from "aos";
import "aos/dist/aos.css";
import "./App.css";
import "./Responsive.css";
import Loader from "../src/components/Loader";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { Suspense, lazy } from "react";
import { PropsProvider } from "./context/PropsContext";
import Cursorpointer from "./components/Cursorpointer";
import BackToTopButton from "./components/BackToTopButton";
const Header = lazy(() => import("./includes/Header"));
const Footer = lazy(() => import("./includes/Footer"));
const HomePage = lazy(() => import("./pages/HomePage"));
const Rollofhonour = lazy(() => import("./pages/About/Rollofhonour"));
const Officebearers = lazy(() => import("./pages/About/Officebearers"));
const Pastpresident = lazy(() => import("./pages/About/Pastpresident"));
const Executivecommittee = lazy(() =>import("./pages/About/executivecommittee"));
const Entrepreneurship = lazy(() => import("./pages/About/Entrepreneurship"));
const Presidentletter = lazy(() => import("./pages/About/Presidentletter"));
const Milestone = lazy(() => import("./pages/About/Milestone"));
const VisionMission = lazy(() => import("./pages/About/VisionMission"));
const MembersBenefits = lazy(() =>import("./pages/Activities/MembersBenefits"));
const Galleryinfo = lazy(() => import("./pages/GalleryPage"));
const Notification = lazy(() => import("./pages/NotificationPage"));
const MOUWithTechnicalInstitutions = lazy(() =>import("./pages/Activities/MOUWithTechnicalInstitutionsPage"));
const Membershipingovtcommittees = lazy(() =>import("./pages/Activities/MembershipingovtcommitteesPage"));
const Sevicesprovided = lazy(() =>import("./pages/Activities/Sevicesprovided"));
const Visitorsbook = lazy(() => import("./pages/Activities/Visitorsbook"));
const Contact = lazy(() => import("./pages/ContactPage"));
const Bulletins = lazy(() => import("./pages/Bulletins/BulletinsPage"));
const Services = lazy(() => import("./pages/ServicesPage"));
const AboutCodissia = lazy(() => import("./pages/About/AboutCodissia"));
const Seniormembers = lazy(() => import("./pages/About/Seniormembers"));
const Codissiamembers = lazy(() => import("./pages/Members/MembersPage"));
// Mmbership
const MembershipPage = lazy(() => import("./pages/MembershipPage"));
const Guidancecell = lazy(() => import("./pages/Activities/GuidancecellPage"));
// Tradefairs
const Tradefairs = lazy(() => import("./pages/Tradefairs"));
const ErrorPage = lazy(() => import("./components/ErrorPage"));
function App() {
useEffect(() => {
  AOS.init({ duration: 1000, once: true });
}, []);
  return (
    <PropsProvider>
      <BrowserRouter>
        <Suspense
          fallback={
            <div className="loading">
              {" "}
              <Loader />{" "}
            </div>
          }
        >
          <Header />
          <Routes>
            <Route path="/" element={<HomePage />} />
            {/* About */}
            <Route path="/roll-of-honour" element={<Rollofhonour />} />
            <Route path="/officebearers" element={<Officebearers />} />
            <Route path="/pastpresident" element={<Pastpresident />} />
            <Route path="/aboutcodissia" element={<AboutCodissia />} />
            <Route path="/executivemembers" element={<Executivecommittee />}/>
            <Route path="/enterpreneurship" element={<Entrepreneurship />} />
            <Route path="/presidentmessage" element={<Presidentletter />} />
            <Route path="/milestones" element={<Milestone />} />
            <Route path="/vision&mission" element={<VisionMission />} />
            <Route path="/bulletins" element={<Bulletins />} />
            <Route path="/notification" element={<Notification />} />
            {/* Activities */}
            <Route path="/membersbenefits" element={<MembersBenefits />} />
            {/* Contact Us */}
            <Route path="/contactus" element={<Contact />} />
            {/* Membership */}
            <Route path="/membership" element={<MembershipPage />} />
            <Route path="/guidancecell" element={<Guidancecell />} />
            <Route path="/mouwithtechnicalinstitutions"element={<MOUWithTechnicalInstitutions />}/>
            <Route path="/membershipingovtcommittees" element={<Membershipingovtcommittees />}/>
            <Route path="/sevicesprovided" element={<Sevicesprovided />} />
            <Route path="/visitorsbook" element={<Visitorsbook />} />
            <Route path="/codissia-members" element={<Codissiamembers />} />
            <Route path="/seniormembers" element={<Seniormembers />} />
            <Route path="/gallery" element={<Galleryinfo />} />
            <Route path="/tradefairs" element={<Tradefairs />} />
            <Route path="/services" element={<Services />} />
            <Route path="*" element={<ErrorPage />} />
          </Routes>
          <BackToTopButton />
          <Footer />
          <Cursorpointer />
        </Suspense>
      </BrowserRouter>
    </PropsProvider>
  );
}

export default App;
