// src/components/BackToTopButton.js
import React, { useState, useEffect } from "react";
import { MdOutlineDoubleArrow } from "react-icons/md";
import { motion } from "framer-motion";


const BackToTopButton = () => {
  const [showButton, setShowButton] = useState(false);

  const handleScroll = () => {
    setShowButton(window.scrollY > 200);
  };

  useEffect(() => {
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const scrollToTop = () => {
    window.scrollTo({ top: 0, behavior: "smooth" });
  };

  return (
    <>
      {showButton && (
        <motion.div
          className="back-to-top"
          initial={{ y: -200, opacity: 0 }}
          animate={{ y: 0, opacity: 1 }}
          transition={{ type: "spring", stiffness: 80, damping: 12 }}
        >
          <button onClick={scrollToTop} className="back-to-top-btn">
            <MdOutlineDoubleArrow className="icon" />
          </button>
        </motion.div>
      )}
    </>
  );
};

export default BackToTopButton;
