import React from "react";
import { useLocation } from "react-router-dom";
import borderbottom from "../assets/bottom-border.png";

const Borderbottom = () => {
  const { pathname } = useLocation();

  // Define custom names based on path
  const routeNameMap = {
    "/": "Home",
    "/presidentmessage": "President Message",
    "/vision&mission": "Vision & Mission",
    "/officebearers": "Office Bearers",
    "/pastpresident": "Past President",
    "/executivecommittee": "Executive Committee",
    "/roll-of-honour": "Roll Of Honour",
    "/membersbenefits": "Members Benefits",
    "/membershipingovtcommittees": "Membership In Govt.Committees",
    "/mouwithtechnicalinstitutions": "Mou With Technical Institutions",
    "/sevicesprovided": "Sevices Provided",
    "/guidancecell": "Guidance Cell",
    "/contactus": "Contact Us",
    "/seniormembers": "Senior Members",
    "/aboutcodissia": "About Codissia",
    "/tradefairs": "Trade Fairs",
  
  };

  // Get custom name or fallback to formatted pathname
  const getCustomPathName = (path) => {
    return routeNameMap[path] || path
      .split("/")
      .filter(Boolean)
      .map((part) => part.charAt(0).toUpperCase() + part.slice(1))
      .join(" / ");
  };

  return (
    <div className="pt-5">
      <div className="container text-center">
        <div>
          <strong className="border-bottom-text">
            {getCustomPathName(pathname)}
          </strong>
        </div>
        <div className="borderbottom">
          <img src={borderbottom} alt="Decorative border" />
        </div>
      </div>
    </div>
  );
};

export default Borderbottom;
