import React from "react";
import { Container } from "react-bootstrap";
import { Link, useLocation } from "react-router-dom";
// import { FiFastForward } from "react-icons/fi";
import data from "../utils/utils";

const BannerWithBreadcrumbs = () => {
  const location = useLocation();
  const pathnames = location.pathname.split('/').filter((x) => x);
  const routeConfig = data().routeConfig[0];
  const currentRoute = pathnames[pathnames.length - 1] || "";
  const bannerImage = routeConfig[currentRoute]?.bannerImage || routeConfig[""].bannerImage;

  return (
    <div className="banner-section">
      <div className="banner-image">
        <img
          src={bannerImage}
          alt="Banner"
          className="img-fluid"
        />
      </div>
      <Container>
        <div className="custom-breadcrumb d-flex">
          {/* <Link to="/">Home</Link> */}
          
          {pathnames.map((name, index) => {
            const routeTo = `/${pathnames.slice(0, index + 1).join('/')}`;
            const isLast = index === pathnames.length - 1;
            const displayName = routeConfig[name]?.displayName || name.replace(/-/g, ' ');

            return (
              <React.Fragment key={name}>
                {/* <div>
                  <FiFastForward className="m-2" />
                </div> */}
                <div>
                  {isLast ? (
                    <span>{displayName}</span>
                  ) : (
                    <Link to={routeTo}>{displayName}</Link>
                  )}
                </div>
              </React.Fragment>
            );
          })}
        </div>
      </Container>
    </div>
  );
};

export default  React.memo(BannerWithBreadcrumbs);