import React, { useEffect, useRef } from 'react';
import gsap from 'gsap';

const CircleFollower = () => {
  const circleRef = useRef(null);

  useEffect(() => {
    const circle = circleRef.current;

    // Move circle with cursor
    const moveCircle = (e) => {
      gsap.to(circle, {
        x: e.clientX,
        y: e.clientY,
        duration: 0.3,
        ease: 'power2.out',
      });
    };

    // Handle hover effects
    const handleMouseEnter = (e) => {
      gsap.to(circle, {
        scale: 2, // Double the size
        backgroundColor: 'rgba(0, 0, 0, 0.8)',
        duration: 0.4,
        ease: 'back.out(1.5)',
      });

      // Add text highlight effect
      const textElement = e.target;
      gsap.to(textElement, {
        color: '#fff',
        textShadow: '0 0 8px rgba(255,255,255,0.7)',
        duration: 0.3,
      });
    };

    const handleMouseLeave = (e) => {
      gsap.to(circle, {
        scale: 1,
        backgroundColor: '#ff3c3c',
        duration: 0.5,
        ease: 'elastic.out(1, 0.5)',
      });

      // Remove text highlight effect
      const textElement = e.target;
      gsap.to(textElement, {
        color: '',
        textShadow: '',
        duration: 0.3,
      });
    };

    window.addEventListener('mousemove', moveCircle);

    // Add event listeners to all elements with class 'hover-target'
    const hoverTargets = document.querySelectorAll('.hover-target');
    hoverTargets.forEach((el) => {
      el.addEventListener('mouseenter', handleMouseEnter);
      el.addEventListener('mouseleave', handleMouseLeave);
      
      // Add basic hover styles if they don't exist
      if (!el.style.transition) {
        el.style.transition = 'color 0.3s, text-shadow 0.3s';
      }
    });

    return () => {
      window.removeEventListener('mousemove', moveCircle);
      hoverTargets.forEach((el) => {
        el.removeEventListener('mouseenter', handleMouseEnter);
        el.removeEventListener('mouseleave', handleMouseLeave);
      });
    };
  }, []);

  const circleStyle = {
    position: 'fixed',
    top: 0,
    left: 0,
    width: '20px',
    height: '20px',
    backgroundColor: '#ff3c3c',
    borderRadius: '50%',
    pointerEvents: 'none',
    zIndex: 1000,
    transform: 'translate(-50%, -50%)',
    mixBlendMode: 'difference',
    willChange: 'transform, background-color', // Optimize for performance
    transformOrigin: 'center center', // Ensure scaling happens from center
  };

  return <div ref={circleRef} style={circleStyle} />;
};

export default CircleFollower;