import React, { useState } from "react";
import { FaExternalLinkAlt } from "react-icons/fa";
import { motion } from "framer-motion";
import {
  FiCalendar,
  FiMapPin,
  FiUsers,
  FiBriefcase,
  FiBook,
  FiLayers,
} from "react-icons/fi";
import {
  FaIndustry,
  FaTools,
  FaWater,
  FaShoppingBag,
  FaBookOpen,
  FaCogs,
  FaBolt,
  FaBoxOpen,
  FaGraduationCap,
  FaRecycle,
} from "react-icons/fa";
import { Container, Row, Col, Card, Nav } from "react-bootstrap";

import complex from "../../assets/images/home/Entrance.png";
import cdiic from "../../assets/images/home/cdiic.png";
import park from "../../assets/images/home/industrialpark.png";

const TradeFairCard = ({ title, description, icon, delay, link }) => {
  const [isHovered, setIsHovered] = useState(false);

  return (
    <motion.div
      initial={{ opacity: 0, y: 20 }}
      animate={{ opacity: 1, y: 0 }}
      transition={{ duration: 0.5, delay: delay * 0.1 }}
      whileHover={{ y: -10 }}
      onHoverStart={() => setIsHovered(true)}
      onHoverEnd={() => setIsHovered(false)}
    >
      <Card className="h-100 shadow-sm border-0">
        <Card.Body className="text-center p-4">
          <motion.div
            animate={{ rotate: isHovered ? 360 : 0 }}
            transition={{ duration: 0.5 }}
            className="bg-danger rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3"
            style={{ width: "64px", height: "64px" }}
          >
            <div className="text-white fs-4">{icon}</div>
          </motion.div>
          <h3 className="h5 fw-bold">{title}</h3>
          <p>{description}</p>
          <a
            href={link}
            target="_blank"
            rel="noopener noreferrer"
            className="visit-btn"
          >
            Visit Website <FaExternalLinkAlt />
          </a>

          <motion.div
            animate={{ x: isHovered ? 5 : 0 }}
            transition={{ type: "spring", stiffness: 300 }}
          ></motion.div>
        </Card.Body>
      </Card>
    </motion.div>
  );
};

const CODISSIAWebsite = () => {
  const [activeTab, setActiveTab] = useState("fairs");

  const tradeFairs = [
    {
      title: "INTEC",
      description:
        "Industrial Trade Fair since 1988 showcasing cutting-edge manufacturing technologies",
      link: "https://www.intec.codissia.com/",
      icon: <FaIndustry />,
    },
    {
      title: "AGRI INTEX",
      description:
        "Agriculture Trade Fair featuring the latest in farming equipment and techniques",
      link: "https://agriintex.codissia.com/",
      icon: <FaTools />,
    },
    {
      title: "BUILD INTEC",
      description:
        "Building and Construction Trade Fair with innovative construction solutions",
      link: "https://www.buildintec.codissia.com/",
      icon: <FiLayers />,
    },
    {
      title: "WATER INTEC",
      description:
        "Water & Waste Water Technologies Fair promoting sustainable water management",
      link: "https://www.waterintec.codissia.com/",
      icon: <FaWater />,
    },
     {
      title: "ELEKTROTEC",
      description:
        "Electrical and Electronics Fair showcasing latest technologies",
      link: "https://www.elektrotec.codissia.com/",
      icon: <FaBolt />,
    },
    {
      title: "COIMBATORE SHOPPING FESTIVAL",
      description:
        "Consumer Fair offering diverse products and shopping experiences",
      link: "https://agriintex.codissia.com/",
      icon: <FaShoppingBag />,
    },
      {
      title: "SUBCON",
      description: "Subcontracting Fair for industrial outsourcing solutions",
      link: "https://www.subcon.codissia.com/",
      icon: <FaCogs />,
    },
    {
      title: "COIMBATORE BOOK FESTIVAL",
      description: "Literary event celebrating books and knowledge sharing",
      link: "https://agriintex.codissia.com/",
      icon: <FaBookOpen />,
    },
    {
      title: "RAW MAT INDIA",
      description: "Raw Material Fair for industrial materials and supplies",
      link: "https://www.rawmat.codissia.com/",
      icon: <FaRecycle />,
    },
      {
      title: "3P EXPO",
      description: "Paper Printing and Packaging fair for packaging solutions",
      link: "https://www.3pexpo.codissia.com/",
      icon: <FaBoxOpen />,
    },
    {
      title: "EDU INTEC",
      description: "Futuristic Learning Aids fair for educational technologies",
      link: "https://www.nstf.codissia.com/", // Assuming this is the correct link
      icon: <FaGraduationCap />,
    },
  
  ];

  return (
    <section>
  <div className="min-vh-100 aboutcodissia ">
      {/* Hero Section */}
      <motion.div
        initial={{ opacity: 0 }}
        animate={{ opacity: 1 }}
        transition={{ duration: 1 }}
        className="position-relative text-dark  overflow-hidden"
      >
        <div className="position-absolute top-0 start-0 w-100 h-100"></div>
        <Container
          className="position-relative z-index-10 pt-5 "
          style={{ textAlign: "justify" }}
        >
          <motion.div
            initial={{ x: -100 }}
            animate={{ x: 0 }}
            transition={{ type: "spring", stiffness: 100 }}
            className="max-w-2xl"
          >
            <p className=" mb-4">
              CODISSIA established in 1969 as a Small Industries Association, is
              one of the largest associations for Micro, Small, and Medium
              Enterprises. It has a membership of more than 1700 MSMEs from
              various sectors.
            </p>
            <p className=" mb-4">
              CODISSIA is a non-profit organization, working for industrial
              development and economic growth and prosperity of this region.
              CODISSIA has made a significant contribution towards building a
              strong and stable industrial belt in this region and creating
              awareness among MSME entrepreneurs
            </p>
            <p className=" mb-4">
              Besides assisting in grievance redressal through effective
              representations, CODISSIA also conducts seminars, training
              programs, facilitate delegation visits to foreign countries,
              exhibitions, industrial trade fairs, industrial visits,
              buyer-seller meets, etc., to create awareness among industrial
              entrepreneurs.
            </p>
            <p className=" mb-4">
              CODISSIA is a member of various advisory and consultative
              committees in government departments at the district and
              statelevels namelyRegional Advisory Committee convened by the
              Commissioner of GST and Central Excise, Coimbatore, Grievance
              Committee of Central Excise, Coimbatore, District Advisory
              Committee and Single Window Concept Programme convened by
              GeneralManager - DIC, Coimbatore and presided over by the District
              Collector, Coimbatore, Consumers Grievance Redressal Committee
              presided over by the Chief Engineer, TANGEDCO,Coimbatore, Raw
              Materials Committee of SIDCO and DIC, Coimbatore, Member in the
              Committee constituted under the implementation of Industrial
              Employment(Standing Orders) Tamil Nadu Amendment Act 2008 and
              etc.,
            </p>
            <p className=" mb-4">
              Additionally, CODISSIA is a member of the Regional Board for ESIC
              (TN), Single Window Committee, AABCS and NEEDS of the Government
              of Tamil Nadu.
            </p>
          </motion.div>
        </Container>
      </motion.div>

      {/* Navigation */}
      <div className="bg-white  sticky-top z-50">
        <Container>
          <Nav variant="pills" className="justify-content-center py-3">
            {[
              "fairs",
              "complex",
              "entrepreneurship",
              "innovation",
              "connect",
            ].map((tab) => (
              <Nav.Item key={tab}>
                <Nav.Link
                  eventKey={tab}
                  onClick={() => setActiveTab(tab)}
                  className={`mx-1 mx-md-3 m-2 rounded-pill ${
                    activeTab === tab ? "active" : ""
                  }`}
                >
                  {tab.charAt(0).toUpperCase() + tab.slice(1)}
                </Nav.Link>
              </Nav.Item>
            ))}
          </Nav>
        </Container>
      </div>

      {/* Main Content */}
      <Container className="py-5">
        {/* Trade Fairs Section */}
        {activeTab === "fairs" && (
          <motion.section
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ duration: 0.5 }}
          >
            <Row className="justify-content-center mb-5">
              <Col lg={12} className="text-center mb-3">
                <h4 className=" fw-bold mb-3">Our Trade Fairs</h4>
                <h5>
                  CODISSIA's trade fairs showcase the latest technologies in
                  respective fields and act as a catalyst for industrial growth.
                </h5>
              </Col>

              <Col lg={6} style={{ textAlign: "justify" }}>
                <p>
                  CODISSIA the expert in expositions, is synonymous with world
                  class Trade Fairs namely INTEC - Industrial Trade Fairsince
                  1988, AGRI INTEX - Agriculture Trade Fair, BUILD INTEC -
                  Building and Construction Trade Fair, SUBCON - Subcontracting
                  Fair, ELEKTROTEC - Electrical and Electronics Fair, COIMBATORE
                  SHOPPING FESTIVAL - Consumer Fair, COIMBATORE BOOK FESTIVAL,
                  RAW MAT INDIA - Raw Material Fair, EDU INTEC - Futuristic
                  Learning Aids fair, 3P EXPO - Paper Printing and Packaging
                  fair and WATER INTEC - Water & Waste Water Technologies Fair.
                </p>
              </Col>
              <Col lg={6} style={{ textAlign: "justify" }}>
                <p>
                  Trade Fairs of CODISSIA not only show case the latest
                  technologies in the respective fields but also act as a
                  catalyst for Industrial growth. The objective of these
                  exhibitions is to give maximum exposure to the entrepreneurs
                  as well as the general public and open new avenues for
                  business generation.
                </p>
              </Col>
              <Col lg={6} style={{ textAlign: "justify" }}>
                <p>
                  CODISSIA revels in its state-of-the- art world class Trade
                  Fair Complex having Asia’s largest pillar free hall with
                  20,000 sq. mt. covers exhibition areain40 acressprawling
                  landscaped land.It is one of the most modern Trade Fair
                  Complex, which has put Coimbatore on the world Industrial&
                  Trade Fair map.
                </p>
              </Col>

              <Col lg={6} style={{ textAlign: "justify" }}>
                <p>
                  CODISSIA has always been actively involved in conducting
                  industrial visits, delegations to International Fairs. We also
                  conduct series of seminars and training Programmes so as to
                  develop and create awareness among industrial entrepreneurs.
                </p>
              </Col>
            </Row>

            <Row className="g-4 justify-content-center">
              {tradeFairs.map((fair, index) => (
                <Col key={fair.title} md={6} lg={4}>
                  <TradeFairCard
                    title={fair.title}
                    description={fair.description}
                    icon={fair.icon}
                    delay={index}
                    link={fair.link} // Pass the link
                  />
                </Col>
              ))}
            </Row>
          </motion.section>
        )}
        {/* Trade Fair Complex Section */}
        {activeTab === "complex" && (
          <motion.section
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ duration: 0.5 }}
          >
            <Row className="align-items-center">
              <Col lg={6}>
                <h4 className=" fw-bold mb-4">
                  State-of-the-Art Trade Fair Complex
                </h4>
                <ul className="list-unstyled">
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiMapPin className="fs-5" />
                    </div>
                    <span>
                      Asia's largest pillar-free hall with 20,000 sq. mt.
                    </span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiCalendar className="fs-5" />
                    </div>
                    <span>40 acres of sprawling landscaped land</span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiUsers className="fs-5" />
                    </div>
                    <span>
                      One of the most modern Trade Fair Complexes in India
                    </span>
                  </motion.li>
                </ul>
              </Col>
              <Col lg={6} className="mt-4 mt-lg-0">
                <motion.div
                  whileHover={{ scale: 1.01 }}
                  className="shadow-lg rounded overflow-hidden"
                >
                  <img
                    src={complex}
                    alt="CODISSIA Trade Fair Complex"
                    className="img-fluid w-100"
                  />
                </motion.div>
              </Col>
            </Row>
          </motion.section>
        )}
        {/* Entrepreneurship Section */}
        {activeTab === "entrepreneurship" && (
          <motion.section
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ duration: 0.5 }}
          >
            <Row className="justify-content-center mb-5">
              <Col lg={12} className="text-center">
                <h4 className=" fw-bold mb-3">Entrepreneurship Development</h4>
                <p className="">
                  One of the main functions of CODISSIA is to offer free
                  guidance to the new entrepreneurs and unemployed youth and
                  motivate them to start their own business availing the
                  benefits extended by Government. In this connection, The
                  Entrepreneurial Guidance Cell meets every Friday in CODISSIA
                  City Office, and gives free guidance to entrepreneurs in
                  various aspects of setting up an Industry, Service
                  Organization and Marketing Centre. They are assisted in the
                  identification and selection of products, preparation of
                  project reports, purchase of machinery & equipment, raw
                  materials, bank finance, marketing of end products, subsidy
                  available from government departments etc.
                </p>
              </Col>
            </Row>

            <Row className="g-4">
              <Col md={4}>
                <motion.div whileHover={{ y: -5 }}>
                  <Card className="h-100 border-0 shadow-sm">
                    <Card.Body className="text-center p-4">
                      <div
                        className="bg-success bg-opacity-10 text-success rounded-circle p-3 mb-3 mx-auto"
                        style={{ width: "64px" }}
                      >
                        <FiBriefcase className="fs-4" />
                      </div>
                      <h3 className="h5 fw-bold">Guidance Cell</h3>
                      <p>
                        Meets every Friday to provide free guidance on setting
                        up industries and businesses
                      </p>
                    </Card.Body>
                  </Card>
                </motion.div>
              </Col>
              <Col md={4}>
                <motion.div whileHover={{ y: -5 }}>
                  <Card className="h-100 border-0 shadow-sm">
                    <Card.Body className="text-center p-4">
                      <div
                        className="bg-info bg-opacity-10 text-info rounded-circle p-3 mb-3 mx-auto"
                        style={{ width: "64px" }}
                      >
                        <FiBook className="fs-4" />
                      </div>
                      <h3 className="h5 fw-bold">Project Reports</h3>
                      <p>
                        Assistance in preparation of project reports and
                        business plans
                      </p>
                    </Card.Body>
                  </Card>
                </motion.div>
              </Col>
              <Col md={4}>
                <motion.div whileHover={{ y: -5 }}>
                  <Card className="h-100 border-0 shadow-sm">
                    <Card.Body className="text-center p-4">
                      <div
                        className="bg-warning bg-opacity-10 text-warning rounded-circle p-3 mb-3 mx-auto"
                        style={{ width: "64px" }}
                      >
                        <FiUsers className="fs-4" />
                      </div>
                      <h3 className="h5 fw-bold">Government Schemes</h3>
                      <p>
                        Information on subsidies and benefits from government
                        departments
                      </p>
                    </Card.Body>
                  </Card>
                </motion.div>
              </Col>
            </Row>
          </motion.section>
        )}
        {/* Innovation Section */}
        {activeTab === "innovation" && (
          <motion.section
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ duration: 0.5 }}
          >
            <Row className=" mb-5">
              <div className="col-12">
                <h4 className=" text-center fw-bold mb-4">
                  CDIIC - CODISSIA DEFENCE INNOVATION AND ATAL INCUBATION CENTRE
                </h4>

                <p className="text-center mb-5">
                  We are proud to mention that CODISSIA has been awarded with
                  the nation’s first Defence Innovation Centre and also the Atal
                  Incubation Centre by NitiAayog (for an Industries Association)
                  under the Innovation for Defence Excellence (iDEX).{" "}
                  <span>
                    {" "}
                    <strong>
                      CODISSIA Defence Innovation and Atal Incubation Centre{" "}
                    </strong>
                  </span>{" "}
                  will be a key contributor to the Southern Defence Corridor
                  enabling the MSMEs of this region to become import
                  substitution partners to the armed forces in the near future.
                  We are sure that this
                  <span className="ms-2 me-2">
                    <strong>
                      CODISSIA Defence Innovation and Atal Incubation Centre
                    </strong>
                  </span>
                  will be instrumental in supporting the Start-ups with
                  innovative ideas, to convert their dream into reality, thus
                  developing more entrepreneurs, in-turn creating more job
                  opportunities in future. This project will be in line with the
                  Start-Up India Mission. Through this, we shall realize the
                  dream of Make in India and equip our country’s armed forces
                  with Indian Solutions.
                </p>
              </div>

              <Col lg={6} className="order-lg-2">
                <h4 className=" fw-bold mb-4"></h4>
                <p className=" mb-4">
                  Nation's first Defence Innovation Centre and Atal Incubation
                  Centre awarded by Niti Aayog
                </p>
                <ul className="list-unstyled">
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiBriefcase className="fs-5" />
                    </div>
                    <span>
                      Key contributor to the Southern Defence Corridor
                    </span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiUsers className="fs-5" />
                    </div>
                    <span>
                      Support for startups with innovative defence solutions
                    </span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiLayers className="fs-5" />
                    </div>
                    <span>Import substitution partners for armed forces</span>
                  </motion.li>
                </ul>
              </Col>
              <Col lg={6} className="order-lg-1 mt-4 mt-lg-0">
                <motion.div
                  whileHover={{ scale: 1.02 }}
                  className="position-relative"
                >
                  <div
                    className="position-absolute top-0 start-0 w-100 h-100 bg-danger bg-opacity-10 rounded"
                    style={{ zIndex: -1 }}
                  ></div>
                  <img
                    src={cdiic}
                    alt="Defence Innovation Centre"
                    className="img-fluid rounded shadow"
                  />
                </motion.div>
              </Col>
            </Row>
            <hr />
            <Row className=" mt-5">
              <div className="col-12 mb-3">
                <h4 className=" text-center fw-bold mb-3">
                  CODISSIA INDUSTRIAL PARKS
                </h4>

                <p className="text-center">
                  CODISSIA has developed two state-of-the-art Industrial Parks
                  at Kallapalayam and Mopperipalayam villages, about 25 km from
                  Coimbatore city. These Industrial Parks are coming up in a
                  total area of close to 400 acres. About 320 MSMEs are setting
                  shops in these two Industrial Parks with an investment in
                  excess of Rs. 3000 crores. These industries will provide
                  direct employment to about 10,000 people and indirectly
                  generate employment opportunities to another 20,000 people.
                  These industrial parks were inauguratedin the year 2019 by the
                  then Honourable Chief Minister of Tamil NaduThiru. Edappadi K
                  Palaniswami.
                </p>
              </div>
              <Col lg={6} className="order-lg-1">
                <p className=" mb-4">
                  State-of-the-art industrial infrastructure driving economic
                  growth in Tamil Nadu
                </p>
                <ul className="list-unstyled">
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiMapPin className="fs-5" />
                    </div>
                    <span>
                      Located at Kallapalayam and Mopperipalayam villages, about
                      25 km from Coimbatore city
                    </span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiLayers className="fs-5" />
                    </div>
                    <span>
                      Spanning 400 acres with 320 MSMEs investing over ₹3000
                      crores
                    </span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiUsers className="fs-5" />
                    </div>
                    <span>
                      Generating 10,000 direct and 20,000 indirect employment
                      opportunities
                    </span>
                  </motion.li>
                  <motion.li
                    whileHover={{ x: 10 }}
                    className="mb-3 d-flex align-items-center"
                  >
                    <div className="bg-danger bg-opacity-10 text-danger rounded-circle p-2 me-3">
                      <FiCalendar className="fs-5" />
                    </div>
                    <span>
                      Inaugurated in 2019 by Honorable CM Thiru. Edappadi K
                      Palaniswami
                    </span>
                  </motion.li>
                </ul>
              </Col>
              <Col
                lg={6}
                className="order-lg-2 mt-4 mt-lg-0 d-flex justify-content-center"
              >
                <motion.div
                  whileHover={{ scale: 1.02 }}
                  className="position-relative"
                >
                  <div
                    className="position-absolute top-0 start-0 w-100 h-100 bg-danger bg-opacity-10 rounded"
                    style={{ zIndex: -1 }}
                  ></div>
                  <img
                    src={park}
                    alt="Defence Innovation Centre"
                    className="img-fluid rounded shadow"
                  />
                </motion.div>
              </Col>
            </Row>
          </motion.section>
        )}
        {activeTab === "connect" && (
          <motion.section
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            transition={{ duration: 0.5 }}
          >
            <Row className=" mb-5">
              <Col lg={6}>
                <h4 className=" fw-bold mb-4">CODISSIA BULLETIN</h4>
                <p style={{ textAlign: "justify" }}>
                  CODISSIA publishes a fortnightly newsletter on the 1st and
                  15th of every calendar month since 1973 which contains current
                  news and recent technical developments. The newsletter is
                  circulated to all members of CODISSIA and other associations
                  in Tamil Nadu, Officers of the State and the Central
                  Governments connected with MSME, VIPs, Banks etc. The team
                  ensures that each issue comes out on time and contains
                  essential and current information as well as articles of
                  general interest.
                </p>
              </Col>
              <Col lg={6}>
                <h4 className=" fw-bold mb-4">
                  INDUSTRY – INSTITUTE PARTNERSHIP
                </h4>
                <p style={{ textAlign: "justify" }}>
                  CODISSIA has signed MOUs with a number of Technological
                  Institutes for mutual benefit and growth and for benefit of
                  students through Industry – academic Institution interaction
                  activities.
                </p>
              </Col>
            </Row>
          </motion.section>
        )}

        <div>
          <div className="col-12">
            <div className="text-center mt-4">
              <h6>
                All the achievements of CODISSIA can be simply spell as{" "}
                <span>
                  <strong style={{ color: "red" }}>
                    TEAM WORK ALWAYS SUCCEEDS.{" "}
                  </strong>
                </span>{" "}
              </h6>
            </div>
          </div>
        </div>
      </Container>
    </div>

    </section>
  
  );
};

export default  React.memo(CODISSIAWebsite);
