import React, { useState, useEffect } from "react";
import { Popover, Typography, IconButton, Box } from "@mui/material";
import { Table, TableBody, TableCell, TableContainer, TableRow, Paper } from "@mui/material";
import CloseIcon from "@mui/icons-material/Close";
import data from "../../utils/utils";
import { FaRegEye } from "react-icons/fa6";

const Executivecommitteeinfo = () => {
  const [presidentsData, setPresidentsData] = useState([]);

  useEffect(() => {
    const fetchData = async () => {
      try {
        let fetchedData = typeof data === "function" ? data() : data;
        if (
          fetchedData &&
          fetchedData.executivecommittee &&
          Array.isArray(fetchedData.executivecommittee)
        ) {
          setPresidentsData(fetchedData.executivecommittee);
        } else {
          console.error("Error: presidentsData is not an array", fetchedData);
        }
      } catch (error) {
        console.error("Error fetching presidents data:", error);
      }
    };

    fetchData();
  }, []);

  const [anchorEl, setAnchorEl] = useState(null);
  const [selectedPresident, setSelectedPresident] = useState(null);

  const handleClick = (event, president) => {
    setAnchorEl(event.currentTarget);
    setSelectedPresident(president);
  };

  const handleClose = () => {
    setAnchorEl(null);
    setSelectedPresident(null);
  };

  return (
    <section>
   <div className="container">
       <div className="row justify-content-center">
        {presidentsData.length > 0 ? (
          presidentsData.map((president, index) => (
            <div
              key={index}
              className="col-xl-3 col-lg-3 col-md-6 col-sm-6 mb-3 p-3"
              onClick={(event) => handleClick(event, president)}
            >
              <div className="d-flex justify-content-center">
                <div className="pastpresident-images img-container">
                  <img
                    className="img-fluid"
                    src={president.img}
                    alt={president.name}
                  />
                  <div className="pastpresident-images-overlay">
                   <FaRegEye/>
                  </div>
                  <div className="president-info">
                    <h4>{president.name}</h4>
                    <Typography variant="subtitle2" sx={{ opacity: 0.8 }}>
                      {president.designation}
                    </Typography>
                  </div>
                </div>
              </div>
            </div>
          ))
        ) : (
          <Typography variant="body1" className="text-center col-span-4">
            Loading past presidents...
          </Typography>
        )}

        {/* Popover */}
        <Popover
          open={Boolean(anchorEl)}
          anchorEl={anchorEl}
          onClose={handleClose}
          anchorReference="anchorPosition"
          anchorPosition={{
            top: window.innerHeight / 2,
            left: window.innerWidth / 2,
          }}
          transformOrigin={{ vertical: "center", horizontal: "center" }}
          PaperProps={{
            sx: {
              p: 3,
              borderRadius: 3,
              boxShadow: 5,
              backgroundColor: "#1E293B",
              color: "#fff",
            },
          }}
        >
          {selectedPresident && (
            <Box textAlign="center">
              <IconButton
                size="small"
                sx={{ position: "absolute", top: 8, right: 8, color: "#fff" }}
                onClick={handleClose}
              >
                <CloseIcon />
              </IconButton>
              
              <Typography variant="p" sx={{ fontWeight: "bold", mt: 2 }}>
                {selectedPresident.name} - <span>{selectedPresident.codissia_role}</span>
              </Typography>
              <Typography variant="subtitle2" sx={{ opacity: 0.8 }}>
                {selectedPresident.designation}
              </Typography>
              <TableContainer component={Paper} sx={{ mt: 2 }}>
                <Table>
                  <TableBody>
                    <TableRow>
                      <TableCell>
                        <strong>Company:</strong>
                      </TableCell>
                      <TableCell>{selectedPresident.company}</TableCell>
                    </TableRow>
                    {selectedPresident.email && (
                      <TableRow>
                        <TableCell>
                          <strong>Email:</strong>
                        </TableCell>
                        <TableCell>{selectedPresident.email}</TableCell>
                      </TableRow>
                    )}
                    {selectedPresident.contact_number && (
                      <TableRow>
                        <TableCell>
                          <strong>Contact:</strong>
                        </TableCell>
                        <TableCell>{selectedPresident.contact_number}</TableCell>
                      </TableRow>
                    )}
                    <TableRow>
                      <TableCell>
                        <strong>Address:</strong>
                      </TableCell>
                      <TableCell>{selectedPresident.address}</TableCell>
                    </TableRow>
                  </TableBody>
                </Table>
              </TableContainer>
            </Box>
          )}
        </Popover>
      </div>
    
    </div>
    </section>
 
  );
};

export default  React.memo(Executivecommitteeinfo);
