import React, { useState, useEffect } from "react";
import { Typography } from "@mui/material";
import ImageLoader from "../ImageLoader";

import data from "../../utils/utils";
import { FaRegEye } from "react-icons/fa6";

const Pastpresidentinfo = () => {
  const [presidentsData, setPresidentsData] = useState([]);

  useEffect(() => {
    const fetchData = async () => {
      try {
        let fetchedData = typeof data === "function" ? data() : data;
        if (
          fetchedData &&
          fetchedData.presidents &&
          Array.isArray(fetchedData.presidents)
        ) {
          setPresidentsData(fetchedData.presidents);
        } else {
          console.error("Error: presidentsData is not an array", fetchedData);
        }
      } catch (error) {
        console.error("Error fetching presidents data:", error);
      }
    };

    fetchData();
  }, []);

  const [anchorEl, setAnchorEl] = useState(null);
  const [selectedPresident, setSelectedPresident] = useState(null);

  const handleClick = (event, president) => {
    // Check if the president has keyword "no" - don't show popover if true
    if (president.keyword !== "no") {
      setAnchorEl(event.currentTarget);
      setSelectedPresident(president);
    }
  };

  const handleClose = () => {
    setAnchorEl(null);
    setSelectedPresident(null);
  };

  return (
    <section>
      <div className="container">
        <div className="row justify-content-center">
          {presidentsData.length > 0 ? (
            <>
              {/* First Section: All except last 6 */}
              {presidentsData.slice(0, -6).map((president, index) => (
                <div
                  key={index}
                  className="col-6 col-sm-6 col-md-4 col-lg-5th mb-3 p-3"
                  onClick={(event) => handleClick(event, president)}
                  style={{
                    cursor: president.keyword === "no" ? "default" : "pointer",
                  }}
                >
                  <div className="d-flex justify-content-center">
                    <div className="pastpresident-images img-container">
                      <img
                        className="img-fluid"
                        src={president.img}
                        alt={president.name}
                      />
                      <div className="president-info">
                        <h4>{president.name}</h4>
                        <h4>{president.content || ""}</h4>
                      </div>
                    </div>
                  </div>
                </div>
              ))}
            </>
          ) : (
            <Typography variant="body1" className="text-center col-span-4">
              <ImageLoader />
            </Typography>
          )}
        </div>
      </div>
    </section>
  );
};

export default React.memo(Pastpresidentinfo);
