import React from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faPenNib } from "@fortawesome/free-solid-svg-icons";
import lettertop from "../../assets/images/president/president-letter.png";

const Presidentletterinfo = () => {
  return (
    <section>
 <div className="container mt-5 president-letter-main">
      <div className="row justify-content-center">
        <div className="col-lg-12">
          <div className="d-flex justify-content-center mb-3 mt-3">
            <img
              className="img-fluid president-letter-bg"
              src={lettertop}
              alt=""
              srcset=""
            />
          </div>
          <div>
            <div className="president-letter-info">
              <div className="mb-4">
                <div>
                  <p className="text-muted">
                    <span className="fw-bold">
                      
                      Dear Members, Industry Partners and Visitors,
                    </span>
                  </p>
                </div>
              </div>

              <div className="mb-4">
                <p className="text-muted">
                  It is with great pride and a deep sense of responsibility that I welcome you to the official website of CODISSIA – The Coimbatore District Small Industries Association.
                </p>
              </div>

              <div className="mb-4">
                <p className="text-muted">
                 For over five decades, CODISSIA has stood as a steadfast pillar of support for the MSME sector, championing the spirit of entrepreneurship and driving industrial growth in Coimbatore and beyond. As President, I am truly honored to lead this dynamic and resilient ecosystem of innovators, manufacturers and business leaders who form the backbone of our region’s economic development.
                </p>
              </div>
              <div className="mb-4">
                <p className="text-muted">
                 Our mission has always been clear — to empower industries through representation, collaboration and innovation. Whether by advocating for progressive policies, promoting technology adoption, or unlocking global market access, CODISSIA continues to serve as a vital bridge between MSMEs and national economic progress.
                </p>
              </div>

             
              <div>
                <p className="text-muted">
                  We are dedicated to helping MSMEs scale effectively by offering strategic guidance, robust infrastructure and comprehensive support. Through a mix of capacity-building programs, trade fairs, technology transfer initiatives and policy advocacy, we nurture an environment where enterprises can grow and thrive. Our industrial parks, incubation centers and business networking platforms provide access to essential resources, skilled talent and new business opportunities. By connecting industry with government and academia, CODISSIA plays a key role in transforming potential into performance.
                </p>
              </div>
              <div>
                <p className="text-muted">
                  On the global front, CODISSIA is committed to opening new horizons for MSMEs. We facilitate participation in international expos, trade delegations and B2B engagements, creating meaningful connections with global buyers, partners and investors. We also offer expert guidance on exports, international standards and certifications, helping businesses confidently navigate global markets. Through strategic alliances with international trade bodies and chambers of commerce, we enable our members to compete and succeed on the world stage.
                </p>
              </div>
              <div>
                <p className="text-muted">
                 In today’s fast-evolving business landscape, we are focused on enhancing our digital capabilities, broadening our services and nurturing the next generation of industrial leaders. This website is an extension of that vision — a hub for information, engagement and inspiration.
                </p>
              </div>
              <div>
                <p className="text-muted">
                  I warmly invite all stakeholders to actively engage with CODISSIA, explore the opportunities we offer and collaborate in building a future that is inclusive, innovative and globally competitive.
                </p>
              </div>

              <div className="d-flex justify-content-end">
                <div className="text-center">
                  <p className="text-muted">
                    Warm regards,
                    <br />
                    <strong style={{ color: "red" }}>M. KarthiKeyan</strong>
                    <br />
                    <span className="fw-bold">President</span>
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div className="d-flex justify-content-center mt-3">
          <img
            className="img-fluid president-letter-bg"
            src={lettertop}
            alt=""
            srcset=""
          />
        </div>
      </div>
    </div>
    </section>
   
  );
};

export default  React.memo(Presidentletterinfo);
