import React, { useState } from "react";
import {
  officebearerspresidents as presidents,
  officebearerhonours as honours,
  officebearertreasrer as treasrer,
} from "../../utils/utils";
// import Borderbottom from "../Borderbottom";
import { motion, AnimatePresence } from "framer-motion";

const PresidentTree = () => {
  const [activeTab, setActiveTab] = useState("PRESIDENT");

  const founder = presidents[0];
  const honour = honours[0];
  const treasurer = treasrer[0];

  const presidentSuccessors = presidents.slice(1);
  const honourSuccessors = honours.slice(1);
  const treasrerSuccessors = treasrer.slice(1);

  const fallingVariants = {
    hidden: {
      y: -100,
      opacity: 0,
      rotate: -5,
    },
    visible: (index) => ({
      y: 0,
      opacity: 1,
      rotate: 0,
      transition: {
        delay: index * 0.1,
        type: "spring",
        damping: 10,
        stiffness: 100,
      },
    }),
  };

  const mainNodeVariants = {
    hidden: {
      y: -150,
      opacity: 0,
      scale: 0.8,
    },
    visible: {
      y: 0,
      opacity: 1,
      scale: 1,
      transition: {
        type: "spring",
        damping: 10,
        stiffness: 100,
      },
    },
  };

  const tabVariants = {
    hidden: { y: -50, opacity: 0 },
    visible: (index) => ({
      y: 0,
      opacity: 1,
      transition: {
        delay: index * 0.1,
        type: "spring",
      },
    }),
  };

  const renderTree = () => {
    switch (activeTab) {
      case "PRESIDENT":
        return (
          <motion.div
            className="tree"
            initial="hidden"
            animate="visible"
            exit={{ opacity: 0 }}
            transition={{ duration: 0.3 }}
            key="president-tree"
          >
            <ul>
              <motion.div
                className="node-main founder"
                variants={mainNodeVariants}
              >
                <strong>
                  <p>{founder.name}</p>
                </strong>
                <span>{founder.years}</span>
              </motion.div>

              <ul className="tree-grid">
                {presidentSuccessors.map((president, index) => (
                  <motion.li
                    key={`president-${president.id}`}
                    custom={index}
                    variants={fallingVariants}
                    initial="hidden"
                    animate="visible"
                  >
                    <div className="node">
                      <strong>
                        <p>{president.name}</p>
                      </strong>
                      <span>{president.years}</span>
                    </div>
                  </motion.li>
                ))}
              </ul>
            </ul>
          </motion.div>
        );

      case "HON.SECRETARY":
        return (
          <motion.div
            className="tree"
            initial="hidden"
            animate="visible"
            exit={{ opacity: 0 }}
            transition={{ duration: 0.3 }}
            key="honour-tree"
          >
            <ul>
              <motion.div
                className="node-main honour"
                variants={mainNodeVariants}
              >
                <strong>
                  <p>{honour.name}</p>
                </strong>
                <span>{honour.years}</span>
              </motion.div>

              <ul className="tree-grid">
                {honourSuccessors.map((honour, index) => (
                  <motion.li
                    key={`honour-${honour.id}`}
                    custom={index}
                    variants={fallingVariants}
                    initial="hidden"
                    animate="visible"
                  >
                    <div className="node">
                      <strong>
                        <p>{honour.name}</p>
                      </strong>
                      <span>{honour.years}</span>
                    </div>
                  </motion.li>
                ))}
              </ul>
            </ul>
          </motion.div>
        );

      case "HON.TREASURER":
        return (
          <motion.div
            className="tree"
            initial="hidden"
            animate="visible"
            exit={{ opacity: 0 }}
            transition={{ duration: 0.3 }}
            key="treasurer-tree"
          >
            <ul>
              <motion.div
                className="node-main treasurer"
                variants={mainNodeVariants}
              >
                <strong>
                  <p>{treasurer.name}</p>
                </strong>
                <span>{treasurer.years}</span>
              </motion.div>

              <ul className="tree-grid">
                {treasrerSuccessors.map((treasurer, index) => (
                  <motion.li
                    key={`treasurer-${treasurer.id}`}
                    custom={index}
                    variants={fallingVariants}
                    initial="hidden"
                    animate="visible"
                  >
                    <div className="node">
                      <strong>
                        <p>{treasurer.name}</p>
                      </strong>
                      <span>{treasurer.years}</span>
                    </div>
                  </motion.li>
                ))}
              </ul>
            </ul>
          </motion.div>
        );

      default:
        return null;
    }
  };

  return (
    <section className="leadership-section leadership-timeline">
      {/* <Borderbottom /> */}
      <div className="container ">
        <motion.div className="tabs">
          {["PRESIDENT", "HON.SECRETARY", "HON.TREASURER"].map((tab, index) => (
            <motion.button
              key={tab}
              className={activeTab === tab ? "tab active" : "tab"}
              onClick={() => setActiveTab(tab)}
              custom={index}
              variants={tabVariants}
              initial="hidden"
              animate="visible"
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
            >
              {tab}
            </motion.button>
          ))}
        </motion.div>

        <div className="tree-container">
          <AnimatePresence mode="wait">{renderTree()}</AnimatePresence>
        </div>
      </div>
    </section>
  );
};

export default  React.memo(PresidentTree);
