import React from "react";
import { motion } from "framer-motion";
import visionbg from "../../assets/images/about/vissionmission/visionmission.svg";
import vision from "../../assets/images/about/vissionmission/vision-1.gif";
import objective from "../../assets/images/about/vissionmission/objective.gif";
import { FiChevronsRight } from "react-icons/fi";

const VisionMissioninfo = () => {
  return (
    <div className="vision-mission-container">
      <div className="container">
        <div className="text-center">
          <h4>
            We at CODISSIA to build up healthy powerful and quality MSME's
            through sustained efforts, firm commitment and a system to review
            continuing suitability of policies and to analyse new ideas for
            continuous improvement, we accomplish this by :
          </h4>
        </div>
        <div className="row">
          <div className="col-lg-5 d-flex justify-content-center align-items-center mb-4 mb-lg-0">
            <div className="d-flex justify-content-center">
            
              <img className="img-fluid" src={vision}/>
            </div>
          </div>
          <div className="col-lg-7">
            <motion.div className="vision-section ">
              <div>
                <h4 className="section-title">Vision & Mission</h4>
                <div
                  style={{
                    height: "4px",
                    width: "100px",
                    background: "linear-gradient(90deg, #ffc107, transparent)",
                    marginTop: "-30px",
                  }}
                ></div>
                <div className="mt-3">
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Planning and developing infrastructure facilities for
                    exposition of products and services through trade fairs and
                    other means
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    To achieve this, we solemnly affirm the commitment to our
                    traditional belief
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Planning and developing infrastructure facilities for
                    exposition of products and services through trade fairs and
                    other means
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Actively contributing valuable inputs for the Policy Makers
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Encouraging Human Resource oriented project to create large
                    employment potentials and helping rapid growth of Nation's
                    Economy
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Assisting industries in grievance redressal
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Moulding budding entrepreneurs to become successful
                    industrialists
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    Creating awareness about environmental protection
                  </motion.p>
                </div>
              </div>
            </motion.div>
          </div>
        </div>
        <div className="row">
       
          <div className="col-lg-5 order-1 order-lg-2 mb-4 mb-lg-0 d-flex justify-content-center align-items-center">
          <div className="d-flex justify-content-center">
              <img src={objective} alt="Vision Image" className=" img-fluid" />
            </div>
          </div>
          <div className="col-lg-7 order-2 order-lg-1">
            <motion.div className="objective-section ">
              <div>
                <h4 className="section-title">Objectives</h4>
                <div
                  style={{
                    height: "4px",
                    width: "100px",
                    background: "linear-gradient(90deg, #ffc107, transparent)",
                    marginTop: "-30px",
                  }}
                ></div>
                <div className="mt-3">
                  <motion.p className="section-content d-flex">
                    <div>
                    <FiChevronsRight/>
                    </div>
                    To promote and protect the Small Industries in Coimbatore
                    District. To take all steps to protect and promote the
                    general interests of the persons engaged in Small Industries
                    in Coimbatore District.
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    To create and encourage a fellow feeling and co-operation
                    among the manufacturers and consumers in Small Industries in
                    Coimbatore District and to evolve a common policy on all
                    subjects involving their common interest.
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    To consider and formulate opinions upon all matters
                    connected with the Small Industries in Coimbatore District.
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    To collect, classify and circulate statistics and other
                    information relating to commercial interests in general and
                    Small Industries in particular.
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    To promote beneficial and other measures relating to the
                    Small Industries and thus obtain by all acknowledged means
                    the readdress as far as possible of grievances of the
                    Industrialists in Small Industries.
                  </motion.p>
                  <motion.p className="section-content d-flex">
                  <div>
                    <FiChevronsRight/>
                    </div>
                    To communicate with and make representations to authorities
                    and Chamber of Commerce and other Mercantile and Public
                    Associations throughout the world and concert and promote
                    measures for the protection and furtherance of the Small
                    Industries and the common good of the persons engaged
                    therein.
                  </motion.p>
                </div>
              </div>
            </motion.div>
          </div>
        </div>
      </div>
      <div className="vision-img">
        <img src={visionbg} alt="Background Image" />
      </div>
    </div>
  );
};

export default  React.memo(VisionMissioninfo);
