import React from "react";
import {
  FaLightbulb,
  FaProjectDiagram,
  FaMoneyBillWave,
  FaGavel,
  FaRegFileAlt,
} from "react-icons/fa";
import { motion } from "framer-motion";
import BorderBottom from '../Borderbottom'

const tilesData = [
  {
    icon: <FaLightbulb />,
    title: "Free Entrepreneurial Guidance",
    description:
      "Every Friday from 3:00 PM to 5:00 PM, CODISSIA offers complimentary one-on-one sessions to guide budding entrepreneurs and unemployed youth.",
  },
  {
    icon: <FaProjectDiagram />,
    title: "End-to-End Project Assistance",
    description:
      "From product selection and project report preparation to machinery procurement and raw material sourcing, CODISSIA provides complete support.",
  },
  {
    icon: <FaMoneyBillWave />,
    title: "Financial & Marketing Support",
    description:
      "Get expert advice on securing bank finance, understanding government subsidies, and effective strategies to market your final product.",
  },
  {
    icon: <FaGavel />,
    title: "Government Schemes & Licensing Help",
    description:
      "Learn about procedures for availing incentives, applying for licenses, and navigating government departments with ease.",
  },
  {
    icon: <FaRegFileAlt />,
    title: "Project Profiles & Outreach",
    description:
      "Access a library of detailed project profiles. CODISSIA also engages in entrepreneurship talks across institutions to inspire and educate future leaders.",
  },
];

const Guidancecellinfo = () => {
  return (
    <section className="guidance-clip-section">
      <div className="container py-5 guidance-clip-wrapper">
        <BorderBottom />
        <div className="row mt-5">
          {tilesData.map((tile, index) => (
            <div className="col-md-6 col-lg-4 mb-4" key={index}>
              <motion.div
                initial={{ x: -200, opacity: 0, rotate: -5 }}
                animate={{ x: 0, opacity: 1, rotate: 0 }}
                transition={{
                  duration: 0.8,
                  delay: index * 0.2,
                  ease: "easeOut",
                }}
              >
                <div className="guidance-clip-tile glassy-tile">
                  <div className="tile-icon">{tile.icon}</div>
                  <h5 className="clip-tile-title">{tile.title}</h5>
                  <p className="clip-tile-desc">{tile.description}</p>
                </div>
              </motion.div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default  React.memo(Guidancecellinfo);
