import React from "react";
import { FaGraduationCap } from "react-icons/fa";
import { motion } from "framer-motion";
import Borderbottom from "../Borderbottom";

const MOUWithTechnicalInstitutionsinfo = () => {
  const institutes = [
    "RVS College of Engg & Technology",
    "Sri Guru Institute of Technology",
    "Amrita Institute of Technology, Ettimadai",
    "Anna University of Technology",
    "Avinashilingam Institute of Home Science and Higher Education for Women",
    "Bannariamman Institute of Technology, Sathyamangalam",
    "Coimbatore Institute of Engineering & Information Technology",
    "Dhanalakshmi Srinivasan College of Engineering",
    "Dr. Mahalingam College of Engineering & Technology, Pollachi",
    "Jansons Institute of Technology",
    "K.S.R College of Engineering",
    "Karpagam College of Arts and Science, Coimbatore",
    "Karunya Institute of Technology & Science",
    "Kathir College of Engineering",
    "Knowledge Park of Engineering and Technology",
    "Kongu Engineering College, Perundurai, Erode District",
    "Kongunadu Arts and Science College",
    "KPR School of Business",
    "Kumaraguru College of Technology",
    "Nachimuthu Polytechnic College, Pollachi",
    "National Small Industries Corporation",
    "Nehru Institute of Engineering & Technology",
    "NGM College",
    "NPA Centenary Polytechnic College, Kothagiri",
    "P.S.G. Industrial Institute",
    "PSGR Krishnammal College for Women",
    "Ranganathan Engineering College",
    "Sakthi Institute of Information & Management Studies",
    "Sree Saraswathi Thyagaraja College",
    "Sri Krishna Engineering College, Sugunapuram, Coimbatore",
    "Sri Ramakrishna Engineering College",
    "Sri Ramakrishna Engineering College, Vattamalaipalayam, Coimbatore",
    "Sri Ramakrishna Institute of Technology",
    "Sri Sakthi Institute of Engineering and Technology",
    "Suguna Polytechnic College, Coimbatore",
    "SVS College of Engineering",
    "Tamil Nadu College of Engineering",
    "Tata Consultancy Services Ltd",
    "The Govt. Polytechnic for Women, Coimbatore",
    "The PSG College of Technology and Polytechnic, Coimbatore",
    "Vivekananda College of Engg for Women",
    "VLB Janakiammal College of Engineering and Technology",
    "VLB Janakiammal Polytechnic, Coimbatore",
  ];

  return (
    <section className="mou-section">
      <Borderbottom/>
 <div className="container">
      <div className="mou-container mt-5">
        <div className="mou-row row justify-content-center">
          {institutes.map((institute, index) => (
            <div className="mou-col col-lg-3 col-md-6 mb-4 h-100" key={index}>
              <motion.div
                initial={{ y: -200, opacity: 0, rotate: -5 }}
                animate={{ y: 0, opacity: 1, rotate: 0 }}
                transition={{
                  duration: 0.8,
                  delay: index * 0.2,
                  ease: "easeOut",
                }}
              >
                <div className="mou-institute-card text-center p-3">
                  <div className="institution-icon mb-2">
                    <FaGraduationCap className="rect-icon" />
                  </div>
                  <h5 className="mou-institute-name">{institute}</h5>
                </div>
              </motion.div>
            </div>
          ))}
        </div>
      </div>
    </div>
    </section>
   
  );
};

export default  React.memo(MOUWithTechnicalInstitutionsinfo);
