import React from "react";
import { Card, Col, Row } from "react-bootstrap";
import {
  FaTools,
  FaChalkboardTeacher,
  FaGlobe,
  FaBookOpen,
  FaUsers,
  FaHandshake,
  FaBuilding,
  FaArrowRight,
} from "react-icons/fa";
import { useNavigate } from "react-router-dom";
import { motion } from "framer-motion";

const benefits = [
  {
    title: "Technical Assistance",
    icon: <FaTools size={30} />,
    text: "Get professional support and guidance for your technical needs.",
  },
  {
    title: "Study Tours",
    icon: <FaChalkboardTeacher size={30} />,
    text: "Participate in enriching study tours for knowledge and networking.",
  },
  {
    title: "Foreign Tours",
    icon: <FaGlobe size={30} />,
    text: "Travel abroad for exclusive industry insights and opportunities.",
  },
  {
    title: "Consultancy Services",
    icon: <FaHandshake size={30} />,
    text: "Access expert consultancy to optimize your business operations.",
  },
  {
    title: "Training Courses",
    icon: <FaBookOpen size={30} />,
    text: "Enhance your skills and knowledge through tailored training courses.",
  },
  {
    title: "Seminars & Conferences",
    icon: <FaUsers size={30} />,
    text: "Attend seminars and conferences to stay updated and network with peers.",
  },
  {
    title: "Liaison Work",
    icon: <FaBuilding size={30} />,
    text: "Benefit from liaison services to facilitate business partnerships and communication.",
  },
  {
    title: "Vendor, Vendee Meet",
    icon: <FaHandshake size={30} />,
    text: "Participate in vendor-vendee meetings to enhance business relationships.",
  },
];

const MembersBenefitsinfo = () => {
  const navigate = useNavigate();

  const handleBecomeMemberClick = () => {
    navigate("/contactus");
  };

  return (
    <section className="members-benefits-info-section">
      <div className="container my-5">
        <Row className="justify-content-center">
          {benefits.map((benefit, index) => (
            <Col
              key={index}
              xs={12}
              sm={6}
              md={6}
              lg={4}
              className="mb-3 benefits-card-main"
            >
              <motion.div
                initial={{ y: -200, opacity: 0, rotate: -5 }}
                animate={{ y: 0, opacity: 1, rotate: 0 }}
                transition={{
                  duration: 0.8,
                  delay: index * 0.2,
                  ease: "easeOut",
                }}
              >
                <Card className="benefit-card mb-3 h-100">
                  <Card.Body>
                    <div className="icon-container">{benefit.icon}</div>
                    <Card.Title>{benefit.title}</Card.Title>
                    <Card.Text>{benefit.text}</Card.Text>
                  </Card.Body>
                </Card>
              </motion.div>
            </Col>
          ))}
        </Row>

        {/* Become a Member Button */}
        <div className="text-center mt-5 become-member-container">
          <p>
            "Join CODISSIA today and unlock endless opportunities for growth,
            innovation, and industrial networking."
          </p>
          <div className="become-member-wrapper">
            <a className="become-member-btn" onClick={handleBecomeMemberClick}>
              <span className="btn-text">Become a Member</span>
              <span className="btn-icon">
                <FaArrowRight />
              </span>
            </a>
          </div>
        </div>
      </div>
    </section>
  );
};

export default  React.memo(MembersBenefitsinfo);
