import React,{useContext} from "react";
import { motion } from "framer-motion";
import cardback from "../../assets/images/activities/govtcommittiee/card-back.png";
import PropsContext from "../../context/PropsContext";
import Borderbottom from "../Borderbottom";

const Membershipingovtcommitteesinfo = () => {
  const { committee = [] } = useContext(PropsContext); 

  return (
    <section className="membershipingovtcommitteesinfo-main">
      <Borderbottom/>
      
      <div className="container mt-5">
        <div className="row d-flex align-items-stretch justify-content-center">
          {committee.map((item, index) => (
            <div className="col-sm-6 col-md-4 col-lg-3 mb-5" key={index}>
              <motion.div
                className="bc-card h-100"
                initial={{ x: -200, opacity: 0, rotate: -5 }}
                animate={{ x: 0, opacity: 1, rotate: 0 }}
                transition={{
                  duration: 0.8,
                  delay: index * 0.2,
                  ease: "easeOut",
                }}
              >
                <div>
                  <img 
                    className="img-fluid card-front" 
                    src={cardback} 
                    alt="Card Front" 
                  />
                </div>

                <div className="bc-card__header">
                  <motion.div
                    className="d-flex justify-content-center align-items-center mb-3"
                    initial={{ y: -30, opacity: 0 }}
                    animate={{ y: 0, opacity: 1 }}
                    transition={{ delay: 0.4 + index * 0.2, duration: 0.5 }}
                  >
                    <motion.img
                      style={{ width: "90px", height: "90px" }}
                      className="img-fluid"
                      src={item.image || "https://avatar.iran.liara.run/public/35"}
                      alt="Avatar"
                      initial={{ scale: 0.5, opacity: 0 }}
                      animate={{ scale: 1, opacity: 1 }}
                      transition={{ delay: 0.5 + index * 0.2, duration: 0.4 }}
                    />
                  </motion.div>
                </div>

                <div className="bc-card__body">
                  <div className="bc-card__details">
                    <div>
                   
                      <h4>{item.name}</h4>
                    </div>
                  <hr  className="mt-3 mb-3"/>
                    <p className="bc-card__detail-item d-flex flex-column text-center">
                      <h4 >Periodicity</h4>
                     <span className="bc-card__detail-label" >{item.periodicity || "-"} </span> 
                    </p>
                    <p className="bc-card__detail-item d-flex flex-column text-center">
                      <h4 >
                        Representation
                      </h4>
                     <span className="bc-card__detail-label" >{item.frequency || "-"} </span> 
                    </p>
                  </div>
                </div>
              </motion.div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default  React.memo(Membershipingovtcommitteesinfo);