import React from "react";
import { motion } from "framer-motion";
import { Container, Row, Col } from "react-bootstrap";
import services1 from "../../assets/images/activities/services/services-1.png";
import services2 from "../../assets/images/activities/services/services-2.png";
import services3 from "../../assets/images/activities/services/services-3.png";
import services4 from "../../assets/images/activities/services/services-4.png";
import services5 from "../../assets/images/activities/services/services-5.png";
import services6 from "../../assets/images/activities/services/services-6.png";
import services7 from "../../assets/images/activities/services/services-7.png";
import services8 from "../../assets/images/activities/services/services-8.png";
import Borderbottom from "../Borderbottom";

const services = [
  {
    img: services1,
    title: "Publishes CODISSIA Bulletin, a fortnightly journal ",
  },
  {
    img: services2,
    title: "Assist New Entrepreneurial Guidance ",
  },
  {
    img: services3,
    title: "Ancillary development ",
  },
  {
    img: services4,
    title: "Help in resolving Industry problems ",
  },
  {
    img: services5,
    title: "Preparation of Detailed Project Reports (DPRs) ",
  },
  {
    img: services6,
    title:
      "Industry - Academia Interaction activities for the benefit of students  ",
  },
  {
    img: services7,
    title:
      "Publishing books on current topics to educate members and others in general ",
  },
  {
    img: services8,
    title:
      " Periodically for the benefit of trade and industries of this region",
  },
];

const Sevicesprovidedinfo = () => {
  return (
    <section className="services-provided-info">
      <Container className="py-5">
        <Borderbottom/>
        <Row className="justify-content-center mt-5">
          {services.map((service, index) => (
            <Col md={6 } lg={4} className="mb-4" key={index}>
              <motion.div
                initial={{ x: -200, opacity: 0, rotate: -5 }}
                animate={{ x: 0, opacity: 1, rotate: 0 }}
                transition={{
                  duration: 0.8,
                  delay: index * 0.2,
                  ease: "easeOut",
                }}
              >
                <div className="clip-card">
                  <img
                    className="img-fluid"
                    src={service.img}
                    alt={service.title}
                  />
                  <div className="overlay">
                    <h5>{service.title}</h5>
                  </div>
                </div>
              </motion.div>
            </Col>
          ))}
        </Row>
      </Container>
    </section>
  );
};

export default  React.memo(Sevicesprovidedinfo);
