import React, { useState, useEffect,useContext } from "react";
import { FaArrowRightLong } from "react-icons/fa6";
import { IoMailUnreadOutline } from "react-icons/io5";
import PropsContext from "../../context/PropsContext";
import Imageloader from "../../components/ImageLoader";
import "react-toastify/dist/ReactToastify.css";
import Enquiry from "../codissiamembers/Enquiry";
import Pagenation from "../codissiamembers/Pagenation";
import Information from "../codissiamembers/Information";



const CardDesign = () => {
  const { members = [], loading, error, handleShow, handleShowDetails } = useContext(PropsContext);

  return (
    <div>
      <div className="grid-row my-5">
        <div className="grid-main">
          {loading ? (
            <div className="d-flex justify-content-center align-items-center">
              <Imageloader/>
            </div>
          ) : error ? (
            <p className="text-danger">{error}</p>
          ) : members && Array.isArray(members) && members.length > 0 ? (
            [...members]
              .sort((a, b) => a.category.localeCompare(b.category)) 
              .map((item) => (
                <div key={item.id} className="mb-5 unique-shape-main-row">
                  <div className="postion-relative">
                    <div className="unique-category">
                      <div className="unique-category-sub">
                        <p>{item.category}</p>
                      </div>
                    </div>
                  </div>

                  <div className="unique-shape-main">
                    <div className="content-card">
                      <h2 className="company-title">{item.company_name}</h2>
                      <p className="description">{item.name}</p>
                      <div className="contacts">
                        <p>{item.phone_number}</p>
                      </div>
                      <div className="email-section">
                        <p className="email">
                          <span>
                            <IoMailUnreadOutline />
                          </span>{" "}
                          {item.email}
                        </p>
                        <button onClick={handleShow} className="send-mail-btn">
                          SEND MAIL
                        </button>
                      </div>
                    </div>
                    <div className="content-title-tab">
                      <p onClick={() => handleShowDetails(item)}>
                        <span>
                          <FaArrowRightLong />
                        </span>
                        MORE DETAILS
                      </p>
                    </div>
                  </div>
                </div>
              ))
          ) : (
            <div className="d-flex justify-content-center align-items-center">
              <img width={500} className="img-fluid" src={notfound} alt="Not Found" />
            </div>
          )}

          {/* Modal for Send Mail */}
          <Enquiry />

          {/* Modal for More Details */}
          <Information />
        </div>
      </div>
      <div className="container">
        <Pagenation />
      </div>
    </div>
  );
};

export default CardDesign;
