import React, { useState, useEffect,useContext } from "react";
import PropsContext from "../../context/PropsContext";



const Categories = () => {
  const { members, setMembers, fetchAllMembers, originalMembers = [] } =  useContext(PropsContext);
  const [selectedCategory, setSelectedCategory] = useState("");

  useEffect(() => {
    fetchAllMembers();
  }, []);
  
  const uniqueCategories = Array.isArray(originalMembers) 
    ? [...new Set(originalMembers.map((member) => member.category))]
    : [];
  
  const handleCategoryChange = (e) => {
    const category = e.target.value;
    setSelectedCategory(category);
  
    if (category) {
      const filteredMembers = originalMembers.filter((member) => member.category === category);
      setMembers(filteredMembers);
    } else {
      setMembers(originalMembers);
    }
  };
  
  const handleReset = () => {
    setSelectedCategory("");
    setMembers(originalMembers);
  };

  return (
    <div className="container d-flex align-items-center justify-content-lg-start justify-content-center mt-md-0 mt-2">
      <div>
        <select
          id="category"
          className="form-select form-select-lg custom-focus-remove"
          value={selectedCategory} 
          onChange={handleCategoryChange}
        >
          <option value="">Select Category</option>
          {uniqueCategories.map((category, index) => (
            <option key={index} value={category}>
              {category}
            </option>
          ))}
        </select>
      </div>
      <div>
        <button className="btn reset-btn w-100 shadow-lg custom-focus-remove" onClick={handleReset}>
          Reset
        </button>
      </div>
    </div>
  );
};

export default Categories;
