import React, { useState,useContext } from "react";
import { Modal, Button, Form } from "react-bootstrap";
import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import apiService from "../../services/apiServices";
import PropsContext from "../../context/PropsContext";



import Map from "../codissiamembers/Map";

export default function Enquiry() {
  const [loadingmsg, setloadingmsg] = useState(false);
  const [error, setError] = useState({});
  const { handleClose, show } =  useContext(PropsContext);
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    mobile: "",
    subject: "",
    message: "",
    address: "",
  });
  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData({ ...formData, [name]: value });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setloadingmsg(true);
    setError({});

    try {
      const response = await apiService.post("enquiry", formData);
      console.log("API Response:", response);

      if (response && response.success) {
        toast.success(response.message || "Form submitted successfully.");
        setFormData({
          name: "",
          email: "",
          mobile: "",
          subject: "",
          message: "",
          address: "",
        });
        setError({});
      } else {
        if (response.errors) {
          console.log("Response Errors:", response.errors);
          setError(response.errors);
          Object.entries(response.errors).forEach(([field, messages]) => {
            messages.forEach((message) => {
              toast.error(`${field}: ${message}`);
            });
          });
        } else {
          toast.error(response.message || "Failed to submit the form.");
        }
      }
    } catch (error) {
      console.error("Submission Error:", error);
      if (error.response && error.response.data && error.response.data.errors) {
        const apiErrors = error.response.data.errors;
        setError(apiErrors);
        Object.entries(apiErrors).forEach(([field, messages]) => {
          messages.forEach((message) => {
            // toast.error(`${field}: ${message}`);
          });
        });
      } else {
        toast.error(error.message || "Failed to submit the form.");
      }
    } finally {
      setloadingmsg(false);
    }
  };

  return (
    <div>
      <Modal show={show} onHide={handleClose} size="lg" centered>
        <Modal.Body className="details-form-main">
          <div className="d-flex flex-column Details-form flex-md-row">
            <div className="form-section  w-100">
              <div className="d-flex row">
                <div className="col-lg-6 order-2 order-lg-1">
                  <div className=" form-deatils">
                    <p>
                      ENTER <span className="text-danger">YOUR DETAILS</span>
                    </p>
                    <Form onSubmit={handleSubmit}>
                      <div className="row">
                        <div className="col-lg-6 col-6">
                          <Form.Group controlId="formName" className="mb-3">
                            <Form.Label>
                              Name <span className="error-text">*</span>
                            </Form.Label>
                            <Form.Control
                              type="text"
                              placeholder="Enter your name"
                              name="name"
                              value={formData.name}
                              onChange={handleChange}
                              isInvalid={!!error.name}
                            />
                            {error.name && (
                              <span className="text-danger">
                                {Array.isArray(error.name)
                                  ? error.name.join(", ")
                                  : error.name}
                              </span>
                            )}
                          </Form.Group>
                        </div>
                        <div className="col-lg-6 col-6">
                          <Form.Group controlId="formEmail" className="mb-3">
                            <Form.Label>
                              Email <span className="error-text">*</span>
                            </Form.Label>
                            <Form.Control
                              type="email"
                              placeholder="Enter your email"
                              name="email"
                              value={formData.email}
                              onChange={handleChange}
                              isInvalid={!!error.email}
                            />
                            {error.email && (
                              <span className="text-danger">
                                {error.email.join(", ")}{" "}
                                {/* Join the error messages if there's more than one */}
                              </span>
                            )}
                          </Form.Group>
                        </div>
                        <div className="col-lg-6 col-6">
                          <Form.Group controlId="formMobile" className="mb-3">
                            <Form.Label>
                              Mobile <span className="error-text">*</span>
                            </Form.Label>
                            <Form.Control
                              type="text"
                              placeholder="Enter your mobile"
                              name="mobile"
                              value={formData.mobile}
                              onChange={handleChange}
                              isInvalid={!!error.mobile}
                            />
                            {error.mobile && (
                              <span className="text-danger">
                                {error.mobile.join(", ")}{" "}
                                {/* Join the error messages if there's more than one */}
                              </span>
                            )}
                          </Form.Group>
                        </div>
                        <div className="col-lg-6  col-6">
                          <Form.Group controlId="formSubject" className="mb-3">
                            <Form.Label>Subject </Form.Label>
                            <Form.Control
                              type="text"
                              rows={3}
                              placeholder="Enter your subject"
                              name="subject"
                              value={formData.subject}
                              onChange={handleChange}
                            />
                          </Form.Group>
                        </div>
                      </div>

                      <Form.Group controlId="formMessage" className="mb-3">
                        <Form.Label>Message</Form.Label>
                        <Form.Control
                          as="textarea"
                          rows={3}
                          placeholder="Enter your message"
                          name="message"
                          value={formData.message}
                          onChange={handleChange}
                        />
                      </Form.Group>

                      <Form.Group controlId="formAddress" className="mb-3">
                        <Form.Label>Address</Form.Label>
                        <Form.Control
                          as="textarea"
                          rows={3}
                          placeholder="Enter your address"
                          name="address"
                          value={formData.address}
                          onChange={handleChange}
                        />
                      </Form.Group>
                      <div className="d-flex justify-content-between">
                        <div className="d-flex justify-content-center align-items-center">
                         
                        </div>
                        <div className="form-btns-mail">
                          <Button className="form-submit" type="submit">
                            {loadingmsg ? "Submitting..." : "Submit"}
                          </Button>
                          <Button className="form-cancel" onClick={handleClose}>
                            CANCEL
                          </Button>
                        </div>
                      </div>

                      {error.message && (
                        <span className="text-danger">{error.message}</span>
                      )}
                    </Form>
                  </div>
                </div>

                <div className="col-lg-6 order-1 order-lg-2">
                  <Map />
                </div>
              </div>
            </div>
          </div>
        </Modal.Body>
      </Modal>

      <ToastContainer />
    </div>
  );
}
