import React, { useState, useEffect,useContext } from "react";
import { Modal, Table, Button } from 'react-bootstrap';
import { IoCloseSharp } from 'react-icons/io5';
import PropsContext from "../../context/PropsContext";


const Information = () => {

  const { members = [], selectedItem, showNew, handleCloseDetails } =  useContext(PropsContext);

  return (
    <div>
      {members && Array.isArray(members) && members.length > 0 && selectedItem ? (
        <Modal show={showNew} onHide={handleCloseDetails} size="md" centered>
          <div className="close-icon-btn" onClick={handleCloseDetails}>
            <IoCloseSharp />
          </div>
          <Modal.Body className="p-4">
            {selectedItem && (
              <>
                <div className="text-center mb-4">
                  <h3 className="info-heading">{selectedItem.company_name}</h3>
                </div>
                <Table borderless className="details-table">
                  <tbody>
                    <tr>
                      <td>Address:</td>
                      <td>{selectedItem.address}</td>
                    </tr>
                    <tr>
                      <td>Phone:</td>
                      <td>{selectedItem.phone_number}</td>
                    </tr>
                    <tr>
                      <td>Email:</td>
                      <td>{selectedItem.email}</td>
                    </tr>
                    <tr>
                      <td>Category:</td>
                      <td>{selectedItem.category}</td>
                    </tr>
                    
                  </tbody>
                </Table>
                {/* <div className="text-center  mt-4">
                  <a className='getintouch' href={`tel:${selectedItem.phone_number}`} >GET IN TOUCH</a>
                </div> */}
              </>
            )}
          </Modal.Body>
        </Modal>
      ) : null} 
    </div>
  );
};

export default Information;
