import React, { useState } from "react";
import PropsContext from "../../context/PropsContext";



const Map = () => {
  const { members = [] } =  useContext(PropsContext);
  const [maploading, setMaploading] = useState(false);
  const address =
    members.length > 0 && members[0].address ? members[0].address : "";
  const encodedAddress = encodeURIComponent(address);

  return (
    <>
     {maploading ? (
        <div>
          <span>Loading......</span>
        </div>
      ) : (
     <div className="map-container">
     
        <iframe
          src={`https://www.google.com/maps?q=${encodedAddress}&output=embed&hl=en`}
          className="map-iframe"
          allowFullScreen=""
          loading="lazy"
          referrerPolicy="no-referrer-when-downgrade"
          title="Google Maps"
          style={{ height: "610px", width: "100%" }}
        ></iframe>
    
    </div>
  )}
    </>
   
  );
};

export default Map;
