import React, { useContext } from "react";
import PropsContext from "../../context/PropsContext"; 



const Pagenation = () => {
  const { currentPage, totalPages, handlePageChange } =  useContext(PropsContext);

  return (
    <div className="d-flex justify-content-center align-items-center">
      {/* Pagination */}
      <div className="pagination">
        <button
          onClick={() => handlePageChange(currentPage - 1)}
          disabled={currentPage === 1}
        >
          &laquo;
        </button>

        <span>
          Page {currentPage} of {totalPages}
        </span>

        <button
          onClick={() => handlePageChange(currentPage + 1)}
          disabled={currentPage === totalPages}
        >
         &raquo;
        </button>
      </div>
    </div>
  );
};

export default Pagenation;
