import * as React from 'react';
import Pagination from '@mui/material/Pagination';
import Stack from '@mui/material/Stack';
import { styled } from '@mui/material/styles';

import PaginationItem from '@mui/material/PaginationItem'; // Import PaginationItem

const CustomPagination = styled(Pagination)(({ theme }) => ({
  '& .MuiPaginationItem-root': {
    color: '#52af77', // Custom color for pagination items
    '&.Mui-selected': {
      backgroundColor: '#52af77', // Selected page background color
      color: '#fff', // Text color of selected page
    },
    '&:hover': {
      backgroundColor: '#f0f0f0', // Hover effect
    },
  },
}));

export default function PaginationSize() {
  return (
    <Stack spacing={2} direction="column" alignItems="center">
      {/* Map letters to pagination */}
      <CustomPagination
        count={letters.length} // Set count to number of letters
        renderItem={(item) => {
          const letter = letters[item.page - 1]; // Get corresponding letter based on page number
          return (
            <PaginationItem 
              {...item} 
              // Manually render the letter inside the PaginationItem
              children={letter} // This overrides the default label
            />
          );
        }}
      />
    </Stack>
  );
}

export const letters = [
  "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O",
  "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
];
