import React, { useState, useEffect, useContext } from "react";
import { CiSearch } from "react-icons/ci";
import PropsContext from "../../context/PropsContext";
import { letters } from "../../utils/utils";
import Categories from "../codissiamembers/Categories";



const Searchbar = () => {
  const placeholders = ["Business...", "Location...", "Pincode..."];
  const [placeholderText, setPlaceholderText] = useState("");
  const [placeholderIndex, setPlaceholderIndex] = useState(0);
  const [charIndex, setCharIndex] = useState(0);
  const [isDeleting, setIsDeleting] = useState(false);
  const [selectedLetter, setSelectedLetter] = useState("");

  const { fetchAlphabetMembers, query, setQuery, fetchMembers } =  useContext(PropsContext);

  useEffect(() => {
    const handleTyping = () => {
      const currentPlaceholder = placeholders[placeholderIndex];

      if (!isDeleting && charIndex < currentPlaceholder.length) {
        setPlaceholderText((prev) => prev + currentPlaceholder[charIndex]);
        setCharIndex((prev) => prev + 1);
      } else if (isDeleting && charIndex > 0) {
        setPlaceholderText((prev) => prev.slice(0, -1));
        setCharIndex((prev) => prev - 1);
      } else if (!isDeleting && charIndex === currentPlaceholder.length) {
        setTimeout(() => setIsDeleting(true), 1000);
      } else if (isDeleting && charIndex === 0) {
        setIsDeleting(false);
        setPlaceholderIndex((prev) => (prev + 1) % placeholders.length);
      }
    };

    const typingInterval = setTimeout(handleTyping, isDeleting ? 50 : 100);

    return () => clearTimeout(typingInterval);
  }, [charIndex, isDeleting, placeholderIndex, placeholders]);

  const handleSearchChange = (e) => {
    const searchQuery = e.target.value;
    setQuery(searchQuery);
    fetchMembers(searchQuery);
  };

  const handleLetterFilter = (letter) => {
    if (selectedLetter === letter) {
      setSelectedLetter(""); 
      fetchAlphabetMembers(""); 
      setQuery(""); 
    } else {
      setSelectedLetter(letter); 
      fetchAlphabetMembers(letter);  
      setQuery(""); 
    }
  };
  return (
    <section className="searchbar-section section-padding">
      <div className="container">
        <div className="d-flex justify-content-center align-items-center">
          <div className="hero-title text-center">
            <h4>LET THE EVERYONE SEE</h4>
            <h2>YOUR BUSINESS</h2>
          </div>
        </div>

        <div className="row section-padding justify-content-center">
          <div className="row">
          <div className="col-lg-8 col-md-6 col-sm-6 col-12 d-flex justify-content-lg-end justify-content-center align-items-center">
            <div className="searchbar-wrapper">
              <div className="searchbar">
                <input
                  type="search"
                  placeholder={`Search for your ${placeholderText}`}
                  className="search-input"
                  value={query}
                  onChange={handleSearchChange}
                />
                <span className="search-icon">
                  <CiSearch />
                </span>
              </div>
            </div>
          </div>
     
            <div className="col-lg-4 col-md-6 col-sm-6 col-12">
              <div>
                <Categories/>
              </div>
            </div>
          </div>
  
         
        </div>

        {/* Alphabetic filter */}
        <div className="row section-padding">
          <div className="text-center note">
            <p>
              {" "}
              <span>*</span>Note: Select The Alphabets To Find The Business You
              Are Searching?<span>*</span>{" "}
            </p>
          </div>
          <div className="col-12 d-flex justify-content-center align-items-center">
            <div className="letter-grid">
              {letters.map((letter, index) => (
                <div
                  key={index}
                  className={`letter ${
                    selectedLetter === letter ? "active" : ""
                  }`}
                  onClick={() => handleLetterFilter(letter)} 
                >
                  {letter}
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Searchbar;
