import Slider from '@mui/material/Slider';
import { styled } from '@mui/material/styles';
import { letters } from "../../utils/utils"; // Import the letters array

const Sliderrange = styled(Slider)(({ theme }) => ({
  display: 'none', // Hidden by default
  [theme.breakpoints.down('sm')]: {
    // Visible for mobile view only
    display: 'block',
    color: '#52af77',
    height: 8,
    '& .MuiSlider-track': {
      border: 'none',
    },
    '& .MuiSlider-thumb': {
      height: 24,
      width: 24,
      backgroundColor: '#fff',
      border: '2px solid currentColor',
      '&:focus, &:hover, &.Mui-active, &.Mui-focusVisible': {
        boxShadow: 'inherit',
      },
      '&::before': {
        display: 'none',
      },
    },
    '& .MuiSlider-valueLabel': {
      lineHeight: 1.2,
      fontSize: 12,
      background: 'unset',
      padding: 0,
      width: 32,
      height: 32,
      borderRadius: '50% 50% 50% 0',
      backgroundColor: '#52af77',
      transformOrigin: 'bottom left',
      transform: 'translate(50%, -100%) rotate(-45deg) scale(0)',
      '&::before': { display: 'none' },
      '&.MuiSlider-valueLabelOpen': {
        transform: 'translate(50%, -100%) rotate(-45deg) scale(1)',
      },
      '& > *': {
        transform: 'rotate(45deg)',
      },
    },
  },
}));

// Slider component to display letters on top
const LetterSlider = () => {
  return (
    <div className="letter-slider-wrapper">
    

      {/* Slider Component */}
      <Sliderrange
        defaultValue={0}
        min={0}
        max={25} // For A-Z
        step={1}
        valueLabelDisplay="auto"
        valueLabelFormat={(value) => letters[value]} // Show letter on thumb
      />
    </div>
  );
};

export default LetterSlider;
