import React from "react";
import { FaPhone, FaEnvelope, FaMapMarkerAlt } from "react-icons/fa";

const ContactAddress = () => {
  return (
    <div className="container codissia-contact-container py-5">
      <div className="row g-4 justify-content-center">
        <div className="col-md-12 col-lg-6">
          <div className="contact-item h-100 ">
            <div className="icon-circle mx-auto mx-md-0 mb-3 ">
              <FaMapMarkerAlt className="contact-icon" />
            </div>
            <div className="contact-text text-center text-white">
              <p className="mb-0 text-white">
                <a href="https://maps.app.goo.gl/xkixvkehsdvVbYh9A" className="text-white">
                  Codissia, G.D.Naidu Towers,
                  <br />
                  Post Bag No.3827,
                  <br />
                  Huzur Road,
                  <br />
                  Coimbatore 641 018,
                  <br />
                  TamilNadu, South India.
                </a>
              </p>
            </div>
          </div>
        </div>

        <div className="col-md-12 col-lg-6">
          <div className="contact-item h-100 ">
            <div className="icon-circle mx-auto mx-md-0 mb-3 ">
              <FaPhone className="contact-icon" />
            </div>
            <div className="contact-text text-center text-white">
              <p className="mb-1">
                {" "}
                <a className="text-white" href="tel:++91 0422-2222396">+91 0422-2222396</a>
              </p>
              <p className="mb-1">
                {" "}
                <a className="text-white" href="tel:++91 0422-2222397">+91 0422-2222397</a>
              </p>
              <p className="mb-0">
                {" "}
                <a className="text-white" href="tel:+91 0422-2222409">+91 0422-2222409</a>{" "}
              </p>
            </div>
          </div>
        </div>

        <div className="col-md-12 col-lg-6">
          <div className="contact-item h-100 ">
            <div className="icon-circle mx-auto mx-md-0 mb-3 ">
              <FaEnvelope className="contact-icon" />
            </div>
            <div className="contact-text text-center text-white">
              <p className="mb-0">
                {" "}
                <a  href="" className="mailto:info@codissia.com text-white">
                  info@codissia.com
                </a>
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default  React.memo(ContactAddress);
