import React from "react";
import { FaMapMarkerAlt, FaPhoneAlt, FaEnvelope } from "react-icons/fa";
import { motion } from "framer-motion";

const ContactDetails = () => {
  return (
    <div className="container contact-details-main">
      <div className="col-md-12 contact-details-section">
        <div className="contact-info-container">
        
          {/* ---------------------- */}
          <div>
            <h4 class="heading-effect">Codissia Trade Fair Complex</h4>
          </div>
          <div className="row ">
            <div className="col-lg-4 mb-5">
              <motion.div
                className=" h-100"
                initial={{ opacity: 0, y: -50 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.6, delay: 0.3 }}
              >
                <div className="contact-info-card contact-info-card-main contact-info-card-main-bg h-100">
                  <div className="contact-icon-abs">
                    <FaMapMarkerAlt />
                  </div>
                  <div className="contact-text">
                    <h3 className="contact-location event-title">
                      Codissia Trade Fair Complex
                    </h3>
                    <div>
                      <a
                        href="https://maps.app.goo.gl/nyxK7wtiyaJMRKxc9"
                        target="_blank"
                      >
                        <p className="contact-address">
                          Codissia,G.V. Fair Grounds,
                        </p>
                        <p className="contact-address">Coimbatore 641 014,</p>
                        <p className="contact-address">
                          TamilNadu, South India.
                        </p>
                      </a>
                    </div>
                  </div>
                </div>
              </motion.div>
            </div>
            <div className="col-lg-4 mb-5">
              <motion.div
                className=" h-100"
                initial={{ opacity: 0, y: -50 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.6, delay: 0.3 }}
              >
                <div className="contact-info-card  h-100">
                  <div className="contact-icon-abs">
                    <FaPhoneAlt />
                  </div>
                  <div className="contact-text">
                    <h3 className="contact-method event-title ">Call Us</h3>
                    <p className="contact-phone">
                      <a href="tel:+91 (422) 2593505/506/507, ">
                       +91 (422) 2593505/506/507,
                      </a>
                    </p>
                   
                    <p className="contact-phone">
                      <a href="tel:+91 0422-2222409">+91 0422-2222409</a>
                    </p>
                  </div>
                </div>
              </motion.div>
            </div>
            <div className="col-lg-4 mb-5">
              <motion.div
                className=" h-100"
                initial={{ opacity: 0, y: -50 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.6, delay: 0.3 }}
              >
                <div className="contact-info-card h-100">
                  <div className="contact-icon-abs">
                    <FaEnvelope />
                  </div>
                  <div className="contact-text">
                    <h3 className="contact-method event-title ">Email Us</h3>
                    <p className="contact-email">
                      <a href="mailto:info@cointec.in">info@cointec.in</a>
                    </p>
                  
                  </div>
                </div>
              </motion.div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default  React.memo(ContactDetails);
