import { MapContainer, TileLayer, Marker, Popup } from "react-leaflet";
import L from "leaflet";
import "leaflet/dist/leaflet.css";
import { useRef } from "react";
import customPinImg from "../../assets/pin.gif";

const Map = () => {
  const centerPosition = [11.0168, 76.9558];
  const markersRef = useRef([]);
  const customIcon = new L.Icon({
    iconUrl: customPinImg,
    iconSize: [50, 50],
    iconAnchor: [25, 50],
    popupAnchor: [0, -50],
    className: "animated-marker",
  });

  // Locations data with website links
  const locations = [

    {
      position: [11.0041927, 76.9743948],
      name: "Codissia",
      description:
        "G.D.Naidu Towers, Post Bag No.3827, Huzur Road, Coimbatore 641 018",
      website: "https://www.codissia.com",
    },
    {
      position: [11.0291, 77.0065],
      name: "Codissia Trade Fair Complex",
      description: "G.V. Fair Grounds, Avinashi Road, Coimbatore 641 014",
      website: "https://www.codissiafair.com",
    },
  ];

  return (
    <div className="map-container-main" style={{ height: "500px", width: "100%", position: "relative" }}>
      <MapContainer
        center={centerPosition}
        zoom={13}
        scrollWheelZoom={false}
        style={{ height: "100%", width: "100%" }}
      >
        <TileLayer
          attribution='&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors'
          url="https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png"
        />

        {locations.map((location, index) => (
          <Marker
            key={index}
            position={location.position}
            icon={customIcon}
            ref={(el) => (markersRef.current[index] = el)}
            eventHandlers={{
              mouseover: (e) => {
                e.target.openPopup();
                e.target.setZIndexOffset(1000);
              },
              mouseout: (e) => {
                e.target.setZIndexOffset(0);
              },
            }}
          >
            <Popup>
              <strong>{location.name}</strong>
              {location.description}
            </Popup>
          </Marker>
        ))}
      </MapContainer>
    </div>
  );
};

export default Map;
