import React, { useRef } from "react";
import { motion, useInView } from "framer-motion";
import StatsSection from "../home/StatsSection";

const AboutUs = () => {
  const ref = useRef(null);
  const isInView = useInView(ref, { once: true, margin: "-100px" });

  const slideIn = {
    hidden: { x: -100, opacity: 0 },
    visible: {
      x: 0,
      opacity: 1,
      transition: { duration: 1, ease: "easeOut" },
    },
  };

  return (
    <div>
      <section className="about-us-main" ref={ref}>
        <div className="container">
          <div className="row">
            <div className="col-md-12 col-lg-5">
              <motion.div
                className="about-info"
                variants={slideIn}
                initial="hidden"
                animate={isInView ? "visible" : "hidden"}
              >
                <div className="section-title text-left mb-3">
                  <h2 className="d-flex justify-content-start underline-animation">
                    ABOUT US
                   
                  </h2>
                </div>
                <p className="fw-800">
                  The Coimbatore District Small Industries Association
                  (CODISSIA) is a non-profit organisation established in the
                  year 1969. For the past 5 decades, it is continuing its
                  dedicated service to serve the Micro, Small and Medium
                  industries (MSME) of the Coimbatore region. The organisation
                  functions with a large membership base of more than 7000
                  Members. The involvement and the team spirit of the members
                  has elevated CODISSIA as one of the torchbearer associations,
                  who served for our nation’s Industrial growth and prosperity.
                </p>
              </motion.div>
            </div>
            <div className="col-md-12 col-lg-7">
              <StatsSection />
            </div>
          </div>
        </div>
      </section>
 
    </div>
  );
};

export default React.memo(AboutUs);
